#include "sources/common.inc"

#define poe EXTERN
#include "sources/sys.inc"

#undef poe
#define poe PUBLIC
#include "sources/writer.inc"

write1:
	ld (0),a		; 3
	inc (iy + Writer__bufferPosition)	; 3
	jr z,f1		; 2 unlikely
	jp (hl)		; 1
f1:	push hl		; 1
	jp Writer_Write_IY__Continue		; 3
write2:

extern g_bCheckCRC

Writer__bufferPosition	equ Writer__Write_IY + 1
;
; hl = buffer start
; bc = buffer size
; ix = this
; ix <- this
; de <- this
Writer_Construct:
	ld a,l  ; check if buffer is 256-byte aligned
	or c
	call nz,SYS_ThrowException

	ld_de_ix

	push hl
	push de
	push bc
	ld hl,write1
	ld bc,write2-write1
	ldir
	pop bc
	pop de
	pop hl

	ld (ix + Writer__crc32 + 0),0xFF
	ld (ix + Writer__crc32 + 1),0xFF
	ld (ix + Writer__crc32 + 2),0xFF
	ld (ix + Writer__crc32 + 3),0xFF

	ld a,(g_bCheckCRC)
	ld (ix + Writer__crc32Enabled),a

	ld (ix + Writer__bufferStart),l
	ld (ix + Writer__bufferStart + 1),h
	ld (ix + Writer__bufferSize),c
	ld (ix + Writer__bufferSize + 1),b
	ld (ix + Writer__bufferPosition),l
	ld (ix + Writer__bufferPosition + 1),h
	add hl,bc
	ld (ix + Writer__bufferEnd),l
	ld (ix + Writer__bufferEnd + 1),h
	dec h
	dec h
	dec h
	ld (ix + Writer__bufferCopyMargin),h
	ld_de_ix
	
	ret


; ix = this
; ix <- this
Writer_Destruct:
	ret

; a = value
; iy = this
; Modifies: hl
Writer_WriteInline_JumpHL_IY	MACRO
	jp (iy)
	ENDM

; a = value
; iy = this
; Modifies: hl
Writer_Write_IY:
	pop hl
	jp (iy)
Writer_Write_IY__Continue:
	push af
	ld a,(iy + Writer__bufferPosition + 1)
	inc a
	ld (iy + Writer__bufferPosition + 1),a
	cp (iy + Writer__bufferEnd + 1)
	call z,Writer_FinishBlock_IY
	pop af
	ret

; bc = byte count (range 3-258)
; hl = -distance
; iy = this
; Modifies: af, bc, de, hl
Writer_Copy_IY:
	ld e,(iy + Writer__bufferPosition)
	ld d,(iy + Writer__bufferPosition + 1)
	add hl,de
	ld a,h
	jr nc,Writer_Copy_IY__Wrap
	cp (iy + Writer__bufferStart + 1)
	jr c,Writer_Copy_IY__Wrap
	ld a,(iy + Writer__bufferCopyMargin)
Writer_Copy_IY__WrapContinue:
	cp d  ; does the destination have a 512 byte margin without wrapping?
	jr c,Writer_Copy_Slow_IY
	ldi
	ldi
	ldir
	ld (iy + Writer__bufferPosition),e
	ld (iy + Writer__bufferPosition + 1),d
	ret
Writer_Copy_IY__Wrap:
	add a,(iy + Writer__bufferSize + 1)
	ld h,a
	ld a,(iy + Writer__bufferCopyMargin)
	cp h  ; does the source have a 512 byte margin without wrapping?
	jp nc,Writer_Copy_IY__WrapContinue
	jp Writer_Copy_Slow_IY

; bc = byte count
; hl = buffer source
; de = buffer destination
; iy = this
; Modifies: af, bc, de, hl
Writer_Copy_Slow_IY:
	ld e,l
	ld d,h
	add hl,bc
	jr c,Writer_Copy_Slow_IY__Split
	ld a,h
	cp (iy + Writer__bufferEnd + 1)
	jp c,Writer_WriteBlock_IY
; hl = end address
Writer_Copy_Slow_IY__Split:
	push bc
	ld c,(iy + Writer__bufferEnd)
	ld b,(iy + Writer__bufferEnd + 1)
	and a
	sbc hl,bc  ; hl = bytes past end
	ex (sp),hl
	pop bc
	push bc
	sbc hl,bc  ; hl = bytes until end
	ld c,l
	ld b,h
	call Writer_WriteBlock_IY
	pop bc
	ld l,(iy + Writer__bufferStart)
	ld h,(iy + Writer__bufferStart + 1)
	ld a,b
	or c
	jp nz,Writer_Copy_Slow_IY
	ret

; bc = byte count
; de = source
; iy = this
; Modifies: af, bc, de, hl
Writer_WriteBlock_IY:
	ld l,(iy + Writer__bufferPosition)
	ld h,(iy + Writer__bufferPosition + 1)
	add hl,bc
	jr c,Writer_WriteBlock_IY__Split
	ld a,h
	cp (iy + Writer__bufferEnd + 1)
	jr nc,Writer_WriteBlock_IY__Split
	and a
	sbc hl,bc
	ex de,hl
	ldir
	ld (iy + Writer__bufferPosition),e
	ld (iy + Writer__bufferPosition + 1),d
	ret
; hl = end address
Writer_WriteBlock_IY__Split:
	push bc
	ld c,(iy + Writer__bufferEnd)
	ld b,(iy + Writer__bufferEnd + 1)
	and a
	sbc hl,bc  ; hl = bytes past end
	ld c,l
	ld b,h
	ex (sp),hl
	sbc hl,bc  ; hl = bytes until end
	ld c,l
	ld b,h
	ex de,hl
	ld e,(iy + Writer__bufferPosition)
	ld d,(iy + Writer__bufferPosition + 1)
	ldir
	ld (iy + Writer__bufferPosition),e
	ld (iy + Writer__bufferPosition + 1),d
	call Writer_FinishBlock_IY
	ex de,hl
	ld l,(ix + Writer__bufferPosition)
	ld h,(ix + Writer__bufferPosition + 1)
	pop bc
	ld a,b
	or c
	jp nz,Writer_WriteBlock_IY
	ret

; ix = this
; hl <- buffer position
; Modifies: af
Writer_FinishBlock:
	push bc
	push de
	push hl
	ld l,(ix + Writer__bufferPosition)
	ld h,(ix + Writer__bufferPosition + 1)
	ld e,(ix + Writer__bufferStart)
	ld d,(ix + Writer__bufferStart + 1)
	and a
	sbc hl,de
	call c,SYS_ThrowException
	jr z,Writer_FinishBlock__Empty
	ld c,l
	ld b,h
	push bc
	push de
	call Writer_UpdateCRC32
	pop de
	pop bc
	call Writer_WriteToFile
Writer_FinishBlock__Empty:
	pop hl
	pop de
	pop bc
	ld a,(ix + Writer__bufferStart)
	ld (ix + Writer__bufferPosition),a
	ld a,(ix + Writer__bufferStart + 1)
	ld (ix + Writer__bufferPosition + 1),a
	ret

; iy = this
; hl <- buffer position
; Modifies: af
Writer_FinishBlock_IY:
	push iy
	ex (sp),ix
	call Writer_FinishBlock
	pop ix
	ret

; bc = byte count
; de = buffer start
; ix = this
; Modifies: af, bc, de, hl
Writer_UpdateCRC32:
	bit 0,(ix + Writer__crc32Enabled)
	ret z
	ex de,hl
	exx
	push bc
	push de
	push hl
	ld e,(ix + Writer__crc32)
	ld d,(ix + Writer__crc32 + 1)
	ld c,(ix + Writer__crc32 + 2)
	ld b,(ix + Writer__crc32 + 3)
	call Writer_CalculateCRC32
	ld (ix + Writer__crc32),e
	ld (ix + Writer__crc32 + 1),d
	ld (ix + Writer__crc32 + 2),c
	ld (ix + Writer__crc32 + 3),b
	pop hl
	pop de
	pop bc
	exx
	ret

; ix = this
; bcde <- crc32
; f <- z: checksum validation disabled
; Modifies: af, bc, de, hl
Writer_GetCRC32:
	ld l,(ix + Writer__crc32)
	ld h,(ix + Writer__crc32 + 1)
	ld c,(ix + Writer__crc32 + 2)
	ld b,(ix + Writer__crc32 + 3)
	ret

; bc' = byte count
; hl' = read address
; bcde = current crc
; ix = this
; bcde <- updated crc
; Modifies: af, bc, de, hl, bc', hl'
Writer_CalculateCRC32:
	exx
	ld a,c  ; convert 16-bit counter bc to two 8-bit counters in b and c
	dec bc
	inc b
	ld c,b
	ld b,a
Writer_CalculateCRC32__Loop:
	ld a,(hl)
	inc hl
	exx
	xor e
	ld l,a
	ld h,0
g_ucCRC32TableHighByte	equ $-1	
	ld a,(hl)
	xor d
	ld e,a
	inc h
	ld a,(hl)
	xor c
	ld d,a
	inc h
	ld a,(hl)
	xor b
	ld c,a
	inc h
	ld b,(hl)
	exx
	djnz Writer_CalculateCRC32__Loop
	dec c
	jp nz,Writer_CalculateCRC32__Loop
	exx
	ret

; ix = this
; Modifies: af, bc, de, hl
Writer_WriteToFile:
	call SYS_ConsoleStatus  ; allow ctrl-c
	ld a,(ix + Writer__fileHandle)
	or a
	ret z
	ld b,a
	ld e,(ix + Writer__bufferStart + 0)
	ld d,(ix + Writer__bufferStart + 1)
	ld l,(ix + Writer__bufferPosition + 0)
	ld h,(ix + Writer__bufferPosition + 1)
	and a
	sbc hl,de
	call SYS_WriteToFileHandle
	call SYS_CheckDOSError
	ret

end
