#include "sources/common.inc"

C_iWriteBufferSize	equ	32768

#define poe EXTERN
#include "sources/inflate.inc"
#include "sources/reader.inc"
#include "sources/writer.inc"

#undef poe
#define poe PUBLIC
#include "sources/sys.inc"

;******************************************************************************
;******************************************************************************

extern free
extern malloc
extern vTerminateWithError
extern vThrowException
extern g_cInputFile
extern g_cOutputFile
extern g_pcReadBuffer
extern g_pcWriteBuffer
extern g_iReadBufferSize
extern g_ulExternalCRC32

;******************************************************************************
;******************************************************************************

public vUpdateExternalCRC32
extern DOS_call_with_check
extern DOS_call

_CONST	equ 0BH
_READ	equ 48H
_WRITE	equ 49H
_ENSURE	equ 46H

;******************************************************************************
;******************************************************************************

vUpdateExternalCRC32:	push	bc
	push de
	exx
	pop bc
	ld hl,(g_pcWriteBuffer)
	exx
	
	ld de,(g_ulExternalCRC32)
	ld bc,(g_ulExternalCRC32+2)
	call Writer_CalculateCRC32
	ld (g_ulExternalCRC32),de
	ld (g_ulExternalCRC32+2),bc
	pop	bc
	ret

;******************************************************************************
;******************************************************************************

ulInflate:	push ix
	push iy
	push de
	
	call Reader_class__New
	ld hl,(g_pcReadBuffer)
	ld bc,(g_iReadBufferSize)
	call Reader_Construct
	push ix
	ld a,(g_cInputFile)
	ld (ix + Reader__fileHandle),a

	call Writer_class__New
	ld hl,(g_pcWriteBuffer)
	ld bc,C_iWriteBufferSize
	call Writer_Construct
	push ix
	ld a,(g_cOutputFile)
	ld (ix + Writer__fileHandle),a

	call Inflate_class__New

	pop de
	pop hl
 	call Inflate_Construct

	call Inflate_Inflate

	push ix
	call Inflate_GetReader
	call SYS_Free
	pop ix
	
	push ix
	call Inflate_GetWriter
	call Writer_GetCRC32
	push hl
	call SYS_Free
	pop hl
	pop ix
	
	push hl
	call SYS_Free
	pop hl

	pop de
	pop iy
	pop ix
	ret

;******************************************************************************
;******************************************************************************
; bc = size
; ix <- allocated memory, filled with 0
SYS_Malloc:
	push hl
	push bc

	ld d,b
	ld e,c
	call malloc
	ex de,hl
	ld_ix_de

	pop bc
	pop hl
	
	ld h,d
	ld l,e
	ld (hl),0
	inc de
	dec bc
	ldir
	ret

;******************************************************************************
;******************************************************************************
; ix = object
SYS_Free:	ld_de_ix
	jp free

;******************************************************************************
;******************************************************************************

SYS_ConsoleStatus:
	ld c,_CONST
	jp DOS_call

;******************************************************************************
;******************************************************************************

SYS_ReadFromFileHandle:
	ld c,_READ
	jp DOS_call_with_check

;******************************************************************************
;******************************************************************************

SYS_WriteToFileHandle:	push bc
	ld c,_WRITE
	call DOS_call_with_check
	pop bc
	ret

;******************************************************************************
;******************************************************************************

SYS_CheckDOSError:
	ret

;******************************************************************************
;******************************************************************************

SYS_ThrowException:	pop de
	jp vThrowException

;******************************************************************************
;******************************************************************************

SYS_TerminateWithError:	ex de,hl
	jp vTerminateWithError

;******************************************************************************
;******************************************************************************

end
