#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "main.h"

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void vSplitPath(char *_szPath, char **_szDirectory, char **_szFileName, char **_szExtension)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	char	*pcLastSlashOrColumn = NULL, *pcC, *pcLastDot = NULL;
	static int	iL;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	for(pcC = _szPath; *pcC; pcC++)
	{
		if((*pcC == '\\') || (*pcC == ':'))
		{
			pcLastSlashOrColumn = pcC;
			pcLastDot = NULL;
		}
		else if(*pcC == '.')
		{
			pcLastDot = pcC;
		}
	}

	if(_szExtension)
	{
		*_szExtension = NULL;
		if(pcLastDot)
		{
			iL = pcC - pcLastDot + 1;
			*_szExtension = (char *) malloc(iL);
			memcpy(*_szExtension, pcLastDot, iL);
		}
	}

	if(!pcLastDot || !_szExtension) pcLastDot = pcC;

	if(_szDirectory)
	{
		*_szDirectory = NULL;
		if(pcLastSlashOrColumn)
		{
			iL = pcLastSlashOrColumn - _szPath + 1;
			*_szDirectory = (char *) malloc(iL + 1);
			memcpy(*_szDirectory, _szPath, iL);
			(*_szDirectory)[iL] = 0;
		}
	}

	if(!pcLastSlashOrColumn) pcLastSlashOrColumn = _szPath - 1;

	if(_szFileName)
	{
		iL = pcLastDot - pcLastSlashOrColumn;
		if(iL > 1)
		{
			*_szFileName = (char *) malloc(iL);
			memcpy(*_szFileName, pcLastSlashOrColumn + 1, iL);
			(*_szFileName)[iL - 1] = 0;
		}
		else
		{
			*_szFileName = NULL;
		}
	}
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
char *szMakePath(char *_szDirectory, char *_szFileName, char *_szExtension)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	static char *szResult, *pcC;
	static int	iLenDirectory, iLenFileName, iLenExtension;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	iLenDirectory = 0;
	iLenFileName = 0;
	iLenExtension = 0;

	if(_szDirectory) iLenDirectory = strlen(_szDirectory);
	if(_szFileName) iLenFileName = strlen(_szFileName);
	if(_szExtension) iLenExtension = strlen(_szExtension);

	szResult = pcC = (char *) malloc(iLenDirectory + iLenFileName + iLenExtension + 1);

	if(iLenDirectory)
	{
		memcpy(pcC, _szDirectory, iLenDirectory);
		pcC += iLenDirectory;
	}

	if(iLenFileName)
	{
		memcpy(pcC, _szFileName, iLenFileName);
		pcC += iLenFileName;
	}

	if(iLenExtension)
	{
		memcpy(pcC, _szExtension, iLenExtension);
		pcC += iLenExtension;
	}

	*pcC = 0;

	return szResult;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void vCreateDirectoryForFile(char *_szFileName)
{
	/*~~~~~~~~~~~~~~~~~~*/
	char	*_szDirectory;
	/*~~~~~~~~~~~~~~~~~~*/

	vSplitPath(_szFileName, &_szDirectory, NULL, NULL);

	if(_szDirectory)
	{
		_szDirectory[strlen(_szDirectory) - 1] = 0;

		DOS_disableErrorCheck();
		if(mkdir(_szDirectory) == -42)
		{
			vCreateDirectoryForFile(_szDirectory);
			if(mkdir(_szDirectory))
			{
				vExit("can't create directory: ", _szDirectory, 1);
			}
		}
		DOS_enableErrorCheck();

		free(_szDirectory);
	}
}
