#include "sources/common.inc"

#define poe EXTERN
#include "sources/reader.inc"
#include "sources/alphabet.inc"
#include "sources/falphabt.inc"
#include "sources/dalphabt.inc"
#include "sources/writer.inc"
#include "sources/sys.inc"

#undef poe
#define poe PUBLIC
#include "sources/inflate.inc"

; hl = file reader
; de = file writer
; ix = this
; ix <- this
; de <- this
Inflate_Construct:
	ld (ix + Inflate__reader),l
	ld (ix + Inflate__reader + 1),h
	ld (ix + Inflate__writer),e
	ld (ix + Inflate__writer + 1),d
	ld_de_ix
	ret

; ix = this
; ix <- this
Inflate_Destruct:
	ret

; ix = this
; de <- file reader
; ix <- file reader
Inflate_GetReader:
	ld e,(ix + Inflate__reader)
	ld d,(ix + Inflate__reader + 1)
	ld_ix_de
	ret

; ix = this
; de <- file reader
; ix <- file reader
Inflate_GetReaderIY:
	ld e,(ix + Inflate__reader)
	ld d,(ix + Inflate__reader + 1)
	ld_iy_de
	ret

; ix = this
; de <- file writer
; ix <- file writer
Inflate_GetWriter:
	ld e,(ix + Inflate__writer)
	ld d,(ix + Inflate__writer + 1)
	ld_ix_de
	ret

; ix = this
Inflate_Inflate:
	push ix
	call Inflate_GetReader
	call Reader_ReadBit
	pop hl
	push af
	push hl
	ld b,2
	call Reader_ReadBits
	pop ix
	call Inflate_InflateBlock
	pop af
	jp nc,Inflate_Inflate
	push ix
	call Inflate_GetWriter
	call Writer_FinishBlock
	pop ix
	ret

; a = block type
; ix = this
Inflate_InflateBlock:
	and a
	jp z,Inflate_InflateUncompressed
	cp 2
	jp c,Inflate_InflateFixedCompressed
	jp z,Inflate_InflateDynamicCompressed
	ld hl,Inflate_invalidBlockTypeError
	jp SYS_TerminateWithError

; ix = this
Inflate_InflateUncompressed:
	push ix
	call Inflate_GetReader
	call Reader_Align
	call Reader_Read
	ld e,a
	call Reader_Read
	ld d,a
	call Reader_Read
	ld l,a
	call Reader_Read
	ld h,a
	pop ix
	scf
	adc hl,de
	ld hl,Inflate_invalidLengthError
	jp nz,SYS_TerminateWithError
	ld a,d
	or e
	ret z
	ld b,e
	dec de
	inc d
	ld c,d
	push ix
	push ix
	call Inflate_GetWriter
	ex (sp),ix
	call Inflate_GetReader
	pop iy
Loop:
	call Reader_Read
	call Writer_Write_IY
	djnz Loop
	dec c
	jp nz,Loop
	pop ix
	ret

; ix = this
Inflate_InflateFixedCompressed:
	push ix
	call FixedAlphabets_class__New
	ld hl,Inflate_literalLengthSymbols
	ld de,Inflate_distanceSymbols
	call FixedAlphabets_Construct
	call FixedAlphabets_GetRoots
	ex (sp),ix

	call Inflate_InflateCompressed

	ex (sp),ix
	call FixedAlphabets_Destruct
	call SYS_Free
	pop ix
	ret

; ix = this
Inflate_InflateDynamicCompressed:
	push ix
	call Inflate_GetReaderIY
	call DynamicAlphabets_class__New
	ld hl,Inflate_literalLengthSymbols
	ld de,Inflate_distanceSymbols
	call DynamicAlphabets_Construct
	call DynamicAlphabets_GetRoots
	ex (sp),ix

	call Inflate_InflateCompressed

	ex (sp),ix
	call DynamicAlphabets_Destruct
	call SYS_Free
	pop ix
	ret

; hl = literal/length alphabet root
; de = distance alphabet root
; ix = this
Inflate_InflateCompressed:
	push ix
	ld c,(ix + Inflate__writer)
	ld b,(ix + Inflate__writer + 1)
	ld_iy_bc
	ld c,(ix + Inflate__reader)
	ld b,(ix + Inflate__reader + 1)
	ld_ix_bc
	call Reader_PrepareReadBitInline
	call Inflate_DecodeLiteralLength
	call Reader_FinishReadBitInline
	pop ix
	ret

; c = inline bit reader state
; hl = literal/length alphabet root
; de = distance alphabet root
; ix = reader
; iy = writer
Inflate_DecodeLiteralLengthInline MACRO
	jp (hl)
	ENDM

Inflate_DecodeLiteralLength:
	Inflate_DecodeLiteralLengthInline

; Literal/length alphabet symbols 0-255
; c = inline bit reader state
; hl = literal/length alphabet root
; de = distance alphabet root
; ix = reader
; iy = writer

value	defl	0
Inflate_WriteLiteral:
	REPT 256
	ld a,value	; 3e 00
	jp (iy)	; fd e9
value	defl	value+1
	ENDR

wlsize	equ	4

; Literal/length alphabet symbol 256
; c = inline bit reader state
; hl = literal/length alphabet root
; de = distance alphabet root
; ix = reader
; iy = writer
Inflate_EndBlock:
	ret


; bc = length
; c' = inline bit reader state
; hl' = literal/length alphabet root
; de' = distance alphabet root
; ix = reader
; iy = writer
Inflate_DecodeDistanceInline	MACRO
	exx
	ex de,hl
	jp (hl)
	ENDM

; Literal/length alphabet symbols 257-285
; c = inline bit reader state
; hl = literal/length alphabet root
; de = distance alphabet root
; ix = reader
; iy = writer
Inflate_CopyLength__0:
	exx
	ld bc,3
	Inflate_DecodeDistanceInline
Inflate_CopyLength__1:
	exx
	ld bc,4
	Inflate_DecodeDistanceInline
Inflate_CopyLength__2:
	exx
	ld bc,5
	Inflate_DecodeDistanceInline
Inflate_CopyLength__3:
	exx
	ld bc,6
	Inflate_DecodeDistanceInline
Inflate_CopyLength__4:
	exx
	ld bc,7
	Inflate_DecodeDistanceInline
Inflate_CopyLength__5:
	exx
	ld bc,8
	Inflate_DecodeDistanceInline
Inflate_CopyLength__6:
	exx
	ld bc,9
	Inflate_DecodeDistanceInline
Inflate_CopyLength__7:
	exx
	ld bc,10
	Inflate_DecodeDistanceInline
Inflate_CopyLength__8:
	call Reader_ReadBitsInline_1
	add a,11
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__9:
	call Reader_ReadBitsInline_1
	add a,13
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__10:
	call Reader_ReadBitsInline_1
	add a,15
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__11:
	call Reader_ReadBitsInline_1
	add a,17
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__12:
	call Reader_ReadBitsInline_2
	add a,19
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__13:
	call Reader_ReadBitsInline_2
	add a,23
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__14:
	call Reader_ReadBitsInline_2
	add a,27
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__15:
	call Reader_ReadBitsInline_2
	add a,31
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__16:
	call Reader_ReadBitsInline_3
	add a,35
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__17:
	call Reader_ReadBitsInline_3
	add a,43
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__18:
	call Reader_ReadBitsInline_3
	add a,51
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__19:
	call Reader_ReadBitsInline_3
	add a,59
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__20:
	call Reader_ReadBitsInline_4
	add a,67
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__21:
	call Reader_ReadBitsInline_4
	add a,83
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__22:
	call Reader_ReadBitsInline_4
	add a,99
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__23:
	call Reader_ReadBitsInline_4
	add a,115
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__24:
	call Reader_ReadBitsInline_5
	add a,131
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__25:
	call Reader_ReadBitsInline_5
	add a,163
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__26:
	call Reader_ReadBitsInline_5
	add a,195
	jp Inflate_DecodeDistance_SetLength
Inflate_CopyLength__27:
	call Reader_ReadBitsInline_5
	add a,227
	jp nc,Inflate_DecodeDistance_SetLength
	exx
	ld c,a
	ld b,1
	Inflate_DecodeDistanceInline
Inflate_CopyLength__28:
	exx
	ld bc,258
	Inflate_DecodeDistanceInline

; a = length
; c' = inline bit reader state
; hl' = literal/length alphabet root
; de' = distance alphabet root
; ix = reader
; iy = writer
Inflate_DecodeDistance_SetLength:
	exx
	ld c,a
	ld b,0
	Inflate_DecodeDistanceInline


; Distance alphabet symbols 0-29
; c = inline bit reader state
; bc = length
; de = literal/length alphabet root
; hl = distance alphabet root
; ix = reader
; iy = writer
Inflate_CopyDistance__0:
	exx
	ld hl,-1
	jp Inflate_CopyAndNext
Inflate_CopyDistance__1:
	exx
	ld hl,-2
	jp Inflate_CopyAndNext
Inflate_CopyDistance__2:
	exx
	ld hl,-3
	jp Inflate_CopyAndNext
Inflate_CopyDistance__3:
	exx
	ld hl,-4
	jp Inflate_CopyAndNext
Inflate_CopyDistance__4:
	call Reader_ReadBitsInline_1
	xor 0x100-5
	jp Inflate_CopyAndNext_SetSmallDistance
Inflate_CopyDistance__5:
	call Reader_ReadBitsInline_1
	xor 0x100-7
	jp Inflate_CopyAndNext_SetSmallDistance
Inflate_CopyDistance__6:
	call Reader_ReadBitsInline_2
	xor 0x100-9
	jp Inflate_CopyAndNext_SetSmallDistance
Inflate_CopyDistance__7:
	call Reader_ReadBitsInline_2
	xor 0x100-13
	jp Inflate_CopyAndNext_SetSmallDistance
Inflate_CopyDistance__8:
	call Reader_ReadBitsInline_3
	xor 0x100-17
	jp Inflate_CopyAndNext_SetSmallDistance
Inflate_CopyDistance__9:
	call Reader_ReadBitsInline_3
	xor 0x100-25
	jp Inflate_CopyAndNext_SetSmallDistance
Inflate_CopyDistance__10:
	call Reader_ReadBitsInline_4
	xor 0x100-33
	jp Inflate_CopyAndNext_SetSmallDistance
Inflate_CopyDistance__11:
	call Reader_ReadBitsInline_4
	xor 0x100-49
	jp Inflate_CopyAndNext_SetSmallDistance
Inflate_CopyDistance__12:
	call Reader_ReadBitsInline_5
	xor 0x100-65
	jp Inflate_CopyAndNext_SetSmallDistance
Inflate_CopyDistance__13:
	call Reader_ReadBitsInline_5
	xor 0x100-97
	jp Inflate_CopyAndNext_SetSmallDistance
Inflate_CopyDistance__14:
	call Reader_ReadBitsInline_6
	xor 0x100-129
	jp Inflate_CopyAndNext_SetSmallDistance
Inflate_CopyDistance__15:
	call Reader_ReadBitsInline_6
	xor 0x100-193
	jp Inflate_CopyAndNext_SetSmallDistance
Inflate_CopyDistance__16:
	call Reader_ReadBitsInline_7
	exx
	cpl
	ld l,a
	ld h,HIGH (0x10000-257)
	jp Inflate_CopyAndNext
Inflate_CopyDistance__17:
	call Reader_ReadBitsInline_7
	exx
	xor LOW (0x10000-385)
	ld l,a
	ld h,HIGH (0x10000-385)
	jp Inflate_CopyAndNext
Inflate_CopyDistance__18:
	call Reader_ReadBitsInline_8
	exx
	cpl
	ld l,a
	ld h,HIGH (0x10000-513)
	jp Inflate_CopyAndNext
Inflate_CopyDistance__19:
	call Reader_ReadBitsInline_8
	exx
	cpl
	ld l,a
	ld h,HIGH (0x10000-769)
	jp Inflate_CopyAndNext
Inflate_CopyDistance__20:
	call Reader_ReadBitsInline_8
	ex af,af'
	call Reader_ReadBitsInline_1
	xor HIGH (0x10000-1025)
	jp Inflate_CopyAndNext_SetBigDistance
Inflate_CopyDistance__21:
	call Reader_ReadBitsInline_8
	ex af,af'
	call Reader_ReadBitsInline_1
	xor HIGH (0x10000-1537)
	jp Inflate_CopyAndNext_SetBigDistance
Inflate_CopyDistance__22:
	call Reader_ReadBitsInline_8
	ex af,af'
	call Reader_ReadBitsInline_2
	xor HIGH (0x10000-2049)
	jp Inflate_CopyAndNext_SetBigDistance
Inflate_CopyDistance__23:
	call Reader_ReadBitsInline_8
	ex af,af'
	call Reader_ReadBitsInline_2
	xor HIGH (0x10000-3073)
	jp Inflate_CopyAndNext_SetBigDistance
Inflate_CopyDistance__24:
	call Reader_ReadBitsInline_8
	ex af,af'
	call Reader_ReadBitsInline_3
	xor HIGH (0x10000-4097)
	jp Inflate_CopyAndNext_SetBigDistance
Inflate_CopyDistance__25:
	call Reader_ReadBitsInline_8
	ex af,af'
	call Reader_ReadBitsInline_3
	xor HIGH (0x10000-6145)
	jp Inflate_CopyAndNext_SetBigDistance
Inflate_CopyDistance__26:
	call Reader_ReadBitsInline_8
	ex af,af'
	call Reader_ReadBitsInline_4
	xor HIGH (0x10000-8193)
	jp Inflate_CopyAndNext_SetBigDistance
Inflate_CopyDistance__27:
	call Reader_ReadBitsInline_8
	ex af,af'
	call Reader_ReadBitsInline_4
	xor HIGH (0x10000-12289)
	jp Inflate_CopyAndNext_SetBigDistance
Inflate_CopyDistance__28:
	call Reader_ReadBitsInline_8
	ex af,af'
	call Reader_ReadBitsInline_5
	xor HIGH (0x10000-16385)
	jp Inflate_CopyAndNext_SetBigDistance
Inflate_CopyDistance__29:
	call Reader_ReadBitsInline_8
	ex af,af'
	call Reader_ReadBitsInline_5
	xor HIGH (0x10000-24577)
	jp Inflate_CopyAndNext_SetBigDistance

; bc = length
; hl = -distance
; c' = inline bit reader state
; de' = literal/length alphabet root
; hl' = distance alphabet root
; ix = reader
; iy = writer
Inflate_CopyAndNextInline	MACRO
	call Writer_Copy_IY
	exx
	ex de,hl
	Inflate_DecodeLiteralLengthInline
	ENDM

; a = -distance
; bc = length
; c' = inline bit reader state
; de' = literal/length alphabet root
; hl' = distance alphabet root
; ix = reader
; iy = writer
Inflate_CopyAndNext_SetSmallDistance:
	exx
	ld l,a
	ld h,-1
	Inflate_CopyAndNextInline

; a = -distance MSB
; a' = ~-distance LSB
; bc = length
; c' = inline bit reader state
; de' = literal/length alphabet root
; hl' = distance alphabet root
; ix = reader
; iy = writer
Inflate_CopyAndNext_SetBigDistance:
	exx
	ld h,a
	ex af,af'
	cpl
	ld l,a
	Inflate_CopyAndNextInline

Inflate_CopyAndNext:
	Inflate_CopyAndNextInline


	rseg data

Inflate_literalLengthSymbols:
	defw  Inflate_WriteLiteral + wlsize*0, Inflate_WriteLiteral + wlsize*1, Inflate_WriteLiteral + wlsize*2, Inflate_WriteLiteral + wlsize*3
	defw  Inflate_WriteLiteral + wlsize*4, Inflate_WriteLiteral + wlsize*5, Inflate_WriteLiteral + wlsize*6, Inflate_WriteLiteral + wlsize*7
	defw  Inflate_WriteLiteral + wlsize*8, Inflate_WriteLiteral + wlsize*9, Inflate_WriteLiteral + wlsize*10, Inflate_WriteLiteral + wlsize*11
	defw  Inflate_WriteLiteral + wlsize*12, Inflate_WriteLiteral + wlsize*13, Inflate_WriteLiteral + wlsize*14, Inflate_WriteLiteral + wlsize*15
	defw  Inflate_WriteLiteral + wlsize*16, Inflate_WriteLiteral + wlsize*17, Inflate_WriteLiteral + wlsize*18, Inflate_WriteLiteral + wlsize*19
	defw  Inflate_WriteLiteral + wlsize*20, Inflate_WriteLiteral + wlsize*21, Inflate_WriteLiteral + wlsize*22, Inflate_WriteLiteral + wlsize*23
	defw  Inflate_WriteLiteral + wlsize*24, Inflate_WriteLiteral + wlsize*25, Inflate_WriteLiteral + wlsize*26, Inflate_WriteLiteral + wlsize*27
	defw  Inflate_WriteLiteral + wlsize*28, Inflate_WriteLiteral + wlsize*29, Inflate_WriteLiteral + wlsize*30, Inflate_WriteLiteral + wlsize*31
	defw  Inflate_WriteLiteral + wlsize*32, Inflate_WriteLiteral + wlsize*33, Inflate_WriteLiteral + wlsize*34, Inflate_WriteLiteral + wlsize*35
	defw  Inflate_WriteLiteral + wlsize*36, Inflate_WriteLiteral + wlsize*37, Inflate_WriteLiteral + wlsize*38, Inflate_WriteLiteral + wlsize*39
	defw  Inflate_WriteLiteral + wlsize*40, Inflate_WriteLiteral + wlsize*41, Inflate_WriteLiteral + wlsize*42, Inflate_WriteLiteral + wlsize*43
	defw  Inflate_WriteLiteral + wlsize*44, Inflate_WriteLiteral + wlsize*45, Inflate_WriteLiteral + wlsize*46, Inflate_WriteLiteral + wlsize*47
	defw  Inflate_WriteLiteral + wlsize*48, Inflate_WriteLiteral + wlsize*49, Inflate_WriteLiteral + wlsize*50, Inflate_WriteLiteral + wlsize*51
	defw  Inflate_WriteLiteral + wlsize*52, Inflate_WriteLiteral + wlsize*53, Inflate_WriteLiteral + wlsize*54, Inflate_WriteLiteral + wlsize*55
	defw  Inflate_WriteLiteral + wlsize*56, Inflate_WriteLiteral + wlsize*57, Inflate_WriteLiteral + wlsize*58, Inflate_WriteLiteral + wlsize*59
	defw  Inflate_WriteLiteral + wlsize*60, Inflate_WriteLiteral + wlsize*61, Inflate_WriteLiteral + wlsize*62, Inflate_WriteLiteral + wlsize*63
	defw  Inflate_WriteLiteral + wlsize*64, Inflate_WriteLiteral + wlsize*65, Inflate_WriteLiteral + wlsize*66, Inflate_WriteLiteral + wlsize*67
	defw  Inflate_WriteLiteral + wlsize*68, Inflate_WriteLiteral + wlsize*69, Inflate_WriteLiteral + wlsize*70, Inflate_WriteLiteral + wlsize*71
	defw  Inflate_WriteLiteral + wlsize*72, Inflate_WriteLiteral + wlsize*73, Inflate_WriteLiteral + wlsize*74, Inflate_WriteLiteral + wlsize*75
	defw  Inflate_WriteLiteral + wlsize*76, Inflate_WriteLiteral + wlsize*77, Inflate_WriteLiteral + wlsize*78, Inflate_WriteLiteral + wlsize*79
	defw  Inflate_WriteLiteral + wlsize*80, Inflate_WriteLiteral + wlsize*81, Inflate_WriteLiteral + wlsize*82, Inflate_WriteLiteral + wlsize*83
	defw  Inflate_WriteLiteral + wlsize*84, Inflate_WriteLiteral + wlsize*85, Inflate_WriteLiteral + wlsize*86, Inflate_WriteLiteral + wlsize*87
	defw  Inflate_WriteLiteral + wlsize*88, Inflate_WriteLiteral + wlsize*89, Inflate_WriteLiteral + wlsize*90, Inflate_WriteLiteral + wlsize*91
	defw  Inflate_WriteLiteral + wlsize*92, Inflate_WriteLiteral + wlsize*93, Inflate_WriteLiteral + wlsize*94, Inflate_WriteLiteral + wlsize*95
	defw  Inflate_WriteLiteral + wlsize*96, Inflate_WriteLiteral + wlsize*97, Inflate_WriteLiteral + wlsize*98, Inflate_WriteLiteral + wlsize*99
	defw  Inflate_WriteLiteral + wlsize*100, Inflate_WriteLiteral + wlsize*101, Inflate_WriteLiteral + wlsize*102, Inflate_WriteLiteral + wlsize*103
	defw  Inflate_WriteLiteral + wlsize*104, Inflate_WriteLiteral + wlsize*105, Inflate_WriteLiteral + wlsize*106, Inflate_WriteLiteral + wlsize*107
	defw  Inflate_WriteLiteral + wlsize*108, Inflate_WriteLiteral + wlsize*109, Inflate_WriteLiteral + wlsize*110, Inflate_WriteLiteral + wlsize*111
	defw  Inflate_WriteLiteral + wlsize*112, Inflate_WriteLiteral + wlsize*113, Inflate_WriteLiteral + wlsize*114, Inflate_WriteLiteral + wlsize*115
	defw  Inflate_WriteLiteral + wlsize*116, Inflate_WriteLiteral + wlsize*117, Inflate_WriteLiteral + wlsize*118, Inflate_WriteLiteral + wlsize*119
	defw  Inflate_WriteLiteral + wlsize*120, Inflate_WriteLiteral + wlsize*121, Inflate_WriteLiteral + wlsize*122, Inflate_WriteLiteral + wlsize*123
	defw  Inflate_WriteLiteral + wlsize*124, Inflate_WriteLiteral + wlsize*125, Inflate_WriteLiteral + wlsize*126, Inflate_WriteLiteral + wlsize*127
	defw  Inflate_WriteLiteral + wlsize*128, Inflate_WriteLiteral + wlsize*129, Inflate_WriteLiteral + wlsize*130, Inflate_WriteLiteral + wlsize*131
	defw  Inflate_WriteLiteral + wlsize*132, Inflate_WriteLiteral + wlsize*133, Inflate_WriteLiteral + wlsize*134, Inflate_WriteLiteral + wlsize*135
	defw  Inflate_WriteLiteral + wlsize*136, Inflate_WriteLiteral + wlsize*137, Inflate_WriteLiteral + wlsize*138, Inflate_WriteLiteral + wlsize*139
	defw  Inflate_WriteLiteral + wlsize*140, Inflate_WriteLiteral + wlsize*141, Inflate_WriteLiteral + wlsize*142, Inflate_WriteLiteral + wlsize*143
	defw  Inflate_WriteLiteral + wlsize*144, Inflate_WriteLiteral + wlsize*145, Inflate_WriteLiteral + wlsize*146, Inflate_WriteLiteral + wlsize*147
	defw  Inflate_WriteLiteral + wlsize*148, Inflate_WriteLiteral + wlsize*149, Inflate_WriteLiteral + wlsize*150, Inflate_WriteLiteral + wlsize*151
	defw  Inflate_WriteLiteral + wlsize*152, Inflate_WriteLiteral + wlsize*153, Inflate_WriteLiteral + wlsize*154, Inflate_WriteLiteral + wlsize*155
	defw  Inflate_WriteLiteral + wlsize*156, Inflate_WriteLiteral + wlsize*157, Inflate_WriteLiteral + wlsize*158, Inflate_WriteLiteral + wlsize*159
	defw  Inflate_WriteLiteral + wlsize*160, Inflate_WriteLiteral + wlsize*161, Inflate_WriteLiteral + wlsize*162, Inflate_WriteLiteral + wlsize*163
	defw  Inflate_WriteLiteral + wlsize*164, Inflate_WriteLiteral + wlsize*165, Inflate_WriteLiteral + wlsize*166, Inflate_WriteLiteral + wlsize*167
	defw  Inflate_WriteLiteral + wlsize*168, Inflate_WriteLiteral + wlsize*169, Inflate_WriteLiteral + wlsize*170, Inflate_WriteLiteral + wlsize*171
	defw  Inflate_WriteLiteral + wlsize*172, Inflate_WriteLiteral + wlsize*173, Inflate_WriteLiteral + wlsize*174, Inflate_WriteLiteral + wlsize*175
	defw  Inflate_WriteLiteral + wlsize*176, Inflate_WriteLiteral + wlsize*177, Inflate_WriteLiteral + wlsize*178, Inflate_WriteLiteral + wlsize*179
	defw  Inflate_WriteLiteral + wlsize*180, Inflate_WriteLiteral + wlsize*181, Inflate_WriteLiteral + wlsize*182, Inflate_WriteLiteral + wlsize*183
	defw  Inflate_WriteLiteral + wlsize*184, Inflate_WriteLiteral + wlsize*185, Inflate_WriteLiteral + wlsize*186, Inflate_WriteLiteral + wlsize*187
	defw  Inflate_WriteLiteral + wlsize*188, Inflate_WriteLiteral + wlsize*189, Inflate_WriteLiteral + wlsize*190, Inflate_WriteLiteral + wlsize*191
	defw  Inflate_WriteLiteral + wlsize*192, Inflate_WriteLiteral + wlsize*193, Inflate_WriteLiteral + wlsize*194, Inflate_WriteLiteral + wlsize*195
	defw  Inflate_WriteLiteral + wlsize*196, Inflate_WriteLiteral + wlsize*197, Inflate_WriteLiteral + wlsize*198, Inflate_WriteLiteral + wlsize*199
	defw  Inflate_WriteLiteral + wlsize*200, Inflate_WriteLiteral + wlsize*201, Inflate_WriteLiteral + wlsize*202, Inflate_WriteLiteral + wlsize*203
	defw  Inflate_WriteLiteral + wlsize*204, Inflate_WriteLiteral + wlsize*205, Inflate_WriteLiteral + wlsize*206, Inflate_WriteLiteral + wlsize*207
	defw  Inflate_WriteLiteral + wlsize*208, Inflate_WriteLiteral + wlsize*209, Inflate_WriteLiteral + wlsize*210, Inflate_WriteLiteral + wlsize*211
	defw  Inflate_WriteLiteral + wlsize*212, Inflate_WriteLiteral + wlsize*213, Inflate_WriteLiteral + wlsize*214, Inflate_WriteLiteral + wlsize*215
	defw  Inflate_WriteLiteral + wlsize*216, Inflate_WriteLiteral + wlsize*217, Inflate_WriteLiteral + wlsize*218, Inflate_WriteLiteral + wlsize*219
	defw  Inflate_WriteLiteral + wlsize*220, Inflate_WriteLiteral + wlsize*221, Inflate_WriteLiteral + wlsize*222, Inflate_WriteLiteral + wlsize*223
	defw  Inflate_WriteLiteral + wlsize*224, Inflate_WriteLiteral + wlsize*225, Inflate_WriteLiteral + wlsize*226, Inflate_WriteLiteral + wlsize*227
	defw  Inflate_WriteLiteral + wlsize*228, Inflate_WriteLiteral + wlsize*229, Inflate_WriteLiteral + wlsize*230, Inflate_WriteLiteral + wlsize*231
	defw  Inflate_WriteLiteral + wlsize*232, Inflate_WriteLiteral + wlsize*233, Inflate_WriteLiteral + wlsize*234, Inflate_WriteLiteral + wlsize*235
	defw  Inflate_WriteLiteral + wlsize*236, Inflate_WriteLiteral + wlsize*237, Inflate_WriteLiteral + wlsize*238, Inflate_WriteLiteral + wlsize*239
	defw  Inflate_WriteLiteral + wlsize*240, Inflate_WriteLiteral + wlsize*241, Inflate_WriteLiteral + wlsize*242, Inflate_WriteLiteral + wlsize*243
	defw  Inflate_WriteLiteral + wlsize*244, Inflate_WriteLiteral + wlsize*245, Inflate_WriteLiteral + wlsize*246, Inflate_WriteLiteral + wlsize*247
	defw  Inflate_WriteLiteral + wlsize*248, Inflate_WriteLiteral + wlsize*249, Inflate_WriteLiteral + wlsize*250, Inflate_WriteLiteral + wlsize*251
	defw  Inflate_WriteLiteral + wlsize*252, Inflate_WriteLiteral + wlsize*253, Inflate_WriteLiteral + wlsize*254, Inflate_WriteLiteral + wlsize*255
	defw  Inflate_EndBlock, Inflate_CopyLength__0, Inflate_CopyLength__1, Inflate_CopyLength__2
	defw  Inflate_CopyLength__3, Inflate_CopyLength__4, Inflate_CopyLength__5, Inflate_CopyLength__6
	defw  Inflate_CopyLength__7, Inflate_CopyLength__8, Inflate_CopyLength__9, Inflate_CopyLength__10
	defw  Inflate_CopyLength__11, Inflate_CopyLength__12, Inflate_CopyLength__13, Inflate_CopyLength__14
	defw  Inflate_CopyLength__15, Inflate_CopyLength__16, Inflate_CopyLength__17, Inflate_CopyLength__18
	defw  Inflate_CopyLength__19, Inflate_CopyLength__20, Inflate_CopyLength__21, Inflate_CopyLength__22
	defw  Inflate_CopyLength__23, Inflate_CopyLength__24, Inflate_CopyLength__25, Inflate_CopyLength__26
	defw  Inflate_CopyLength__27, Inflate_CopyLength__28, SYS_ThrowException, SYS_ThrowException

Inflate_distanceSymbols:
	defw  Inflate_CopyDistance__0, Inflate_CopyDistance__1, Inflate_CopyDistance__2, Inflate_CopyDistance__3
	defw  Inflate_CopyDistance__4, Inflate_CopyDistance__5, Inflate_CopyDistance__6, Inflate_CopyDistance__7
	defw  Inflate_CopyDistance__8, Inflate_CopyDistance__9, Inflate_CopyDistance__10, Inflate_CopyDistance__11
	defw  Inflate_CopyDistance__12, Inflate_CopyDistance__13, Inflate_CopyDistance__14, Inflate_CopyDistance__15
	defw  Inflate_CopyDistance__16, Inflate_CopyDistance__17, Inflate_CopyDistance__18, Inflate_CopyDistance__19
	defw  Inflate_CopyDistance__20, Inflate_CopyDistance__21, Inflate_CopyDistance__22, Inflate_CopyDistance__23
	defw  Inflate_CopyDistance__24, Inflate_CopyDistance__25, Inflate_CopyDistance__26, Inflate_CopyDistance__27
	defw  Inflate_CopyDistance__28, Inflate_CopyDistance__29, SYS_ThrowException, SYS_ThrowException

Inflate_invalidBlockTypeError:
	defb 'invalid block type',0

Inflate_invalidLengthError:
	defb 'invalid length',0

end
