#include "sources/common.inc"

#define poe EXTERN
#include "sources/alphabet.inc"
#include "sources/sys.inc"

#undef poe
#define poe PUBLIC
#include "sources/falphabt.inc"

; hl = literal/length symbol handlers table
; de = distance symbol handlers table
; ix = this
; ix <- this
; de <- this
FixedAlphabets_Construct:
	push de
	push ix
	call FixedAlphabets_GetLiteralLengthAlphabet
	ld bc,FixedAlphabets_literalLengthCodeLengthsCount
	ld de,FixedAlphabets_literalLengthCodeLengths
	call Alphabet_Construct
	pop ix
	pop hl
	push ix
	call FixedAlphabets_GetDistanceAlphabet
	ld bc,FixedAlphabets_distanceCodeLengthsCount
	ld de,FixedAlphabets_distanceCodeLengths
	call Alphabet_Construct
	pop ix
	ld_de_ix
	ret

; ix = this
; ix <- this
FixedAlphabets_Destruct:
	push ix
	call FixedAlphabets_GetDistanceAlphabet
	call Alphabet_Destruct
	pop ix
	push ix
	call FixedAlphabets_GetLiteralLengthAlphabet
	call Alphabet_Destruct
	pop ix
	ret

; ix = this
FixedAlphabets_GetLiteralLengthAlphabet:
	ld de,FixedAlphabets__literalLengthAlphabet
	add ix,de
	ret

; ix = this
FixedAlphabets_GetDistanceAlphabet:
	ld de,FixedAlphabets__distanceAlphabet
	add ix,de
	ret

; ix = this
; hl <- literal/length alphabet root
; de <- distance alphabet root
FixedAlphabets_GetRoots:
	push ix
	call FixedAlphabets_GetDistanceAlphabet
	ld e,(ix + Alphabet__root)
	ld d,(ix + Alphabet__root + 1)
	pop ix
	push de
	push ix
	call FixedAlphabets_GetLiteralLengthAlphabet
	ld l,(ix + Alphabet__root)
	ld h,(ix + Alphabet__root + 1)
	pop ix
	pop de
	ret

;
FixedAlphabets_literalLengthCodeLengths:
	defb 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8  ; 0-143: 8
	defb 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8
	defb 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8
	defb 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8
	defb 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8
	defb 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8
	defb 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9  ; 144-255: 9
	defb 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
	defb 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
	defb 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9
	defb 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7  ; 256-279: 7
	defb 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8  ; 280-287: 8

FixedAlphabets_literalLengthCodeLengthsCount equ $ - FixedAlphabets_literalLengthCodeLengths

FixedAlphabets_distanceCodeLengths:
	defb 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5
	defb 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5

FixedAlphabets_distanceCodeLengthsCount equ $ - FixedAlphabets_distanceCodeLengths

end
