#ifndef SofaCas_h
#define SofaCas_h

#include <stdio.h>

void vMyError(int _iCode, const char *_pcFormat, ...);
bool bNoUserStop();
void vUpdateUserStop();
void vProcessArguments(int argc, char **argv, char *module, void(*_callback)(char *));
char * szFixedString(const char * mess);
FILE *myfopen(char *_szFileName, bool _bWrite);

extern const unsigned char ASCII[10];
extern const unsigned char BIN[10];
extern const unsigned char BASIC[10];

typedef struct
{
	char				m_FileTypeBlocID[4];	/* Constante "RIFF" (0x52,0x49,0x46,0x46) */
	unsigned int		m_FileSize;				/* Taille du fichier moins 8 octets */
	char				m_FileFormatID[4];		/* Format = "WAVE" (0x57,0x41,0x56,0x45) */

	char				m_FormatBlocID[4];		/* Identifiant "fmt" (0x66,0x6D, 0x74,0x20) */
	unsigned int		m_BlocSize;				/* Nombre d'octets du bloc - 16 (0x10) */

	unsigned short int	m_AudioFormat;			/* Format du stockage dans le fichier (1: PCM, ...) */
	unsigned short int	m_NbrCanaux;			/* Nombre de canaux (de 1  6, cf. ci-dessous) */
	unsigned int		m_Frequence;			/* Frquence d'chantillonnage (en hertz) [Valeurs standardises :
												 * 11025, 22050, 44100 et ventuellement 48000 et 96000] */
	unsigned int		m_BytePerSec;			/* Nombre d'octets  lire par seconde (i.e., Frequence * BytePerBloc). */
	unsigned short int	m_BytePerBloc;			/* Nombre d'octets par bloc d'chantillonnage (i.e., tous canaux
												 * confondus : NbrCanaux * BitsPerSample/8). */
	unsigned short int	m_BitsPerSample;		/* Nombre de bits utiliss pour le codage de chaque chantillon (8, 16,
												 * 24) */

	char				m_DataBlocID[4];		/* Constante "data" (0x64,0x61,0x74,0x61) */
	unsigned int		m_DataSize;				/* Nombre d'octets des donnes (i.e. "Data[]", i.e. taille_du_fichier
												 * taille_de_l'entte (qui fait 44 octets normalement). */
} tdWavHeader;

extern tdWavHeader g_oWaveHeader;
extern bool g_bDoNotAskBeforeOverwritingFile;
extern bool g_bUserCanStop;

#endif
