#include <conio.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>

#include "sofacas.h"
#include "playcas.h"
#include "reccas.h"

bool	g_bDoNotAskBeforeOverwritingFile = false;
bool	g_bUserStop = false;
bool	g_bUserCanStop = false;

const unsigned char ASCII[10] = { 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA, 0xEA };
const unsigned char BIN[10] = { 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0xD0 };
const unsigned char BASIC[10] = { 0xD3, 0xD3, 0xD3, 0xD3, 0xD3, 0xD3, 0xD3, 0xD3, 0xD3, 0xD3 };

tdWavHeader g_oWaveHeader =
{
	{ 0x52, 0x49, 0x46, 0x46 },
	0, { 0x57, 0x41, 0x56, 0x45 },
	{ 0x66, 0x6D, 0x74, 0x20 },
	16,
	1,
	1,
	0,
	0,
	2,
	16, { 0x64, 0x61, 0x74, 0x61 },
	0
};

/*
 =======================================================================================================================
 =======================================================================================================================
 */
char *szFixedString(const char *mess)
{
	/*~~~~~~~~~~~~~~*/
	char	*szResult;
	/*~~~~~~~~~~~~~~*/

	szResult = (char *) malloc(strlen(mess) + 1);
	CharToOem(mess, szResult);
	return szResult;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
FILE *myfopen(char *_szFileName, bool _bWrite)
{
	/*~~~~~~~~~~~~~~*/
	FILE	*poResult;
	/*~~~~~~~~~~~~~~*/

	poResult = fopen(_szFileName, "rb");

	if(_bWrite)
	{
		if(poResult && (!g_bDoNotAskBeforeOverwritingFile))
		{
			/*~~~~~~~~~~~~*/
			char	cAnswer;
			/*~~~~~~~~~~~~*/

			fclose(poResult);
			printf("File \"%s\" already exists. Overwrite (y/n)? ", _szFileName);
			do
			{
				cAnswer = tolower(getch());
			} while((cAnswer != 'y') && (cAnswer != 'n'));
			printf("%c\n", cAnswer);

			if(cAnswer == 'n')
			{
				vMyError(0, "");
			}
		}
		poResult = fopen(_szFileName, "wb");
	}

	if(!poResult) vMyError(-1, "Unable to open file %s", _szFileName);

	return poResult;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void vProcessArguments(int argc, char **argv, char *module, void (*_callback) (char *))
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/
	long	i;
	TCHAR	szFileName[MAX_PATH];
	FILE	*poINIFile;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/

	GetModuleFileName(NULL, szFileName, MAX_PATH);
	strcpy(szFileName + strlen(szFileName) - 4, module);
	strcat(szFileName, ".ini");

	if(poINIFile = fopen(szFileName, "rt"))
	{
		/*~~~~~~~~~~~~~~~~~*/
		char	acLine[1024];
		char	*pcC;
		/*~~~~~~~~~~~~~~~~~*/

		while(fgets(acLine, sizeof(acLine), poINIFile))
		{
			if(acLine[0] != '#')
			{
				pcC = acLine;
				while(*pcC)
				{
					/*~~~~~~~~~~~~*/
					char	*pcNext;
					/*~~~~~~~~~~~~*/

					for
					(
						pcNext = pcC;
						*pcNext && (*pcNext != ' ') && (*pcNext != '\t') && (*pcNext != 13) && (*pcNext != 10);
						pcNext++
					);
					if(*pcNext)
					{
						*pcNext = 0;
						pcNext++;
					}

					if(*pcC) _callback(pcC);
					pcC = pcNext;
				}
			}
		}

		fclose(poINIFile);
		printf("Configuration file read.\n\n");
	}

	/* Parse command line options */
	for(i = 1; i < argc; i++) _callback(argv[i]);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
bool bNoUserStop()
{
	return !g_bUserStop;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void vUpdateUserStop()
{
	if( g_bUserCanStop)
	{
		if(((1 << 16) & GetAsyncKeyState(VK_ESCAPE)) != 0) g_bUserStop = true;
	}
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void vMyError(int _iCode, const char *_pcFormat, ...)
{
	/*~~~~~~~*/
	va_list va;
	/*~~~~~~~*/

	va_start(va, _pcFormat);
	vfprintf(stderr, _pcFormat, va);
	va_end(va);
	fprintf(stderr, "\n");
	if (_iCode)
	{
		printf("Press any key to exit...\n");
		getch();
	}

	exit(_iCode);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
int main(int argc, char *argv[])
{
	/*~~~~~~~~*/
	bool	bOK;
	/*~~~~~~~~*/

	SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_TIME_CRITICAL);

	printf("\n\
SofaCas version 1.3, coded by Louthrax in May 2016\n\
==================================================\n\
\n");

	bOK = false;

	if(argc >= 2)
	{
		if(!strcmp(argv[1], "rec"))
		{
			iRecMain(argc, argv);
			bOK = true;
		}
		else if(!strcmp(argv[1], "play"))
		{
			iPlayMain(argc, argv);
			bOK = true;
		}
	}

	if(!bOK)
	{
		vShowPlayUsage(argv[0]);
		printf("\n\n");
		vShowRecUsage(argv[0]);
	}
}
