#ifndef SerialPort_H
#define SerialPort_H

#include <windows.h>

enum
{
	SERIAL_CD_ON = 0,
	SERIAL_CD_OFF
};

enum
{
	SIG_MODEM_EVENTS = 0,
	SIG_MODEM_CHECKED,
	SERIAL_SIGNAL_NBR
};

typedef void (*type_myCallBack) (UINT32 object, UINT32 event);

class SerialPort
{
protected:
    HANDLE        m_ahSerialEvents[SERIAL_SIGNAL_NBR];  // events to wait on
    unsigned int  m_uiThreadID;                          // ...
    HANDLE        m_hSerialHandle;                     // ...
    HANDLE        m_hThreadHandle;                     // ...
    OVERLAPPED    m_oWaitEvent;                       // Overlapped structure for WaitCommEvent
    char          m_cWaitCommEventInProgress;
    DWORD         m_ulCommEvent;                       // to store the result of the wait
    type_myCallBack m_fManagerCallBack;

    void          OnEvent(unsigned long events);

public:
    SerialPort();
    ~SerialPort();

	void          run          (void);
    int           connect          (char *port);
    void          setManager       (type_myCallBack manager);
};
/* -------------------------------------------------------------------- */

#endif SerialPort_H


