#include <process.h>
#include <windows.h>

#include "SerialPort.h"
#include "sofacas.h"

typedef unsigned (WINAPI *PBEGINTHREADEX_THREADFUNC) (LPVOID lpThreadParameter);

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void SerialPort_thread_start(void *arg)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	class SerialPort	*serial_unit;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	serial_unit = (SerialPort *) arg;

	if(serial_unit != 0) serial_unit->run();
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
SerialPort::SerialPort()
{
	/*~~*/
	int i;
	/*~~*/

	m_uiThreadID = 0;
	m_hSerialHandle = INVALID_HANDLE_VALUE;
	m_hThreadHandle = 0;
	m_cWaitCommEventInProgress = 0;

	m_fManagerCallBack = 0;

	/* creating Events for the different sources */
	for(i = 0; i < SERIAL_SIGNAL_NBR; i++)
	{
		if(i == SIG_MODEM_EVENTS) m_ahSerialEvents[i] = CreateEvent(NULL, TRUE, FALSE, NULL);	/* Manual Reset */
		else
			m_ahSerialEvents[i] = CreateEvent(NULL, FALSE, FALSE, NULL);						/* Auto reset */
	}
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
SerialPort::~SerialPort()
{
	/*~~*/
	int i;
	/*~~*/

	TerminateThread(m_hThreadHandle, 0);
	m_hThreadHandle = 0;

	for(i = 0; i < SERIAL_SIGNAL_NBR; i++)
	{
		if(m_ahSerialEvents[i] != INVALID_HANDLE_VALUE) CloseHandle(m_ahSerialEvents[i]);
		m_ahSerialEvents[i] = INVALID_HANDLE_VALUE;
	}

	if(m_hSerialHandle != INVALID_HANDLE_VALUE) CloseHandle(m_hSerialHandle);
	m_hSerialHandle = INVALID_HANDLE_VALUE;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
int SerialPort::connect(char *port_arg)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	int				iError;
	DCB				dcb;
	int				i;
	COMMTIMEOUTS	cto = { 0, 0, 0, 0, 0 };
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	if(m_hSerialHandle != INVALID_HANDLE_VALUE) CloseHandle(m_hSerialHandle);
	m_hSerialHandle = INVALID_HANDLE_VALUE;

	if(port_arg != 0)
	{
		iError = 0;
		ZeroMemory(&m_oWaitEvent, sizeof(m_oWaitEvent));

		memset(&dcb, 0, sizeof(dcb));
		dcb.DCBlength = sizeof(dcb);

		dcb.BaudRate = 19200;

		dcb.ByteSize = 8;
		dcb.fRtsControl = RTS_CONTROL_HANDSHAKE;

		m_hSerialHandle = CreateFile(port_arg, GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);

		/* opening serial port */
		m_oWaitEvent.hEvent = m_ahSerialEvents[SIG_MODEM_EVENTS];

		if(m_hSerialHandle != INVALID_HANDLE_VALUE)
		{
			if(!SetCommMask(m_hSerialHandle, 0x1FFF)) iError = 1;
			if(!SetCommState(m_hSerialHandle, &dcb)) iError = 4;
		}
		else
			iError = 8;
	}
	else
		iError = 16;

	for(i = 0; i < SERIAL_SIGNAL_NBR; i++)
	{
		if(m_ahSerialEvents[i] == INVALID_HANDLE_VALUE) iError = 32;
	}

	if(iError)
	{
		CloseHandle(m_hSerialHandle);
		m_hSerialHandle = INVALID_HANDLE_VALUE;
	}
	else
	{
		/* start thread */
		m_hThreadHandle = (HANDLE) _beginthreadex
			(
				NULL,
				0,
				(PBEGINTHREADEX_THREADFUNC) SerialPort_thread_start,
				this,
				0,
				&m_uiThreadID
			);
	}

	return iError;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void SerialPort::setManager(type_myCallBack manager_arg)
{
	m_fManagerCallBack = manager_arg;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void SerialPort::OnEvent(unsigned long events)
{
	/*~~~~~~~~~~~~~~~~~~~~~~*/
	unsigned long	ModemStat;
	/*~~~~~~~~~~~~~~~~~~~~~~*/

	GetCommModemStatus(m_hSerialHandle, &ModemStat);

	if((events & EV_RLSD) != 0)
	{
		if((ModemStat & MS_RLSD_ON) != 0)
		{
			if(m_fManagerCallBack != 0) m_fManagerCallBack((UINT32) this, SERIAL_CD_ON);
		}
		else
		{
			if(m_fManagerCallBack != 0) m_fManagerCallBack((UINT32) this, SERIAL_CD_OFF);
		}
	}
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void SerialPort::run(void)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~*/
	unsigned long	result_nbr;
	/*~~~~~~~~~~~~~~~~~~~~~~~*/

	m_cWaitCommEventInProgress = 0;

	GetLastError(); /* Clear any pending error */
	SetEvent(m_ahSerialEvents[SIG_MODEM_CHECKED]);

	while(true)
	{
		switch(WaitForMultipleObjects(SERIAL_SIGNAL_NBR, m_ahSerialEvents, FALSE, INFINITE) - WAIT_OBJECT_0)
		{
		case SIG_MODEM_CHECKED:
			if(!m_cWaitCommEventInProgress)
			{
				m_cWaitCommEventInProgress = 1;

				if(!WaitCommEvent(m_hSerialHandle, &m_ulCommEvent, &m_oWaitEvent))
				{
					if(GetLastError() != ERROR_IO_PENDING) vMyError(-1, "Serial error.");
				}
			}
			break;

		case SIG_MODEM_EVENTS:
			if(GetOverlappedResult(m_hSerialHandle, &m_oWaitEvent, &result_nbr, FALSE))
			{
				ResetEvent(m_ahSerialEvents[SIG_MODEM_EVENTS]);
				m_cWaitCommEventInProgress = 0;

				OnEvent(m_ulCommEvent);

				/* Automatically start a new check */
				SetEvent(m_ahSerialEvents[SIG_MODEM_CHECKED]);
			}
			else
			{
				if(GetLastError() != ERROR_IO_PENDING) vMyError(-1, "Serial error.");
			}
			break;
		}
	}
}
