#ifndef AudioOutput_h
#define AudioOutput_h

#include <windows.h>
#include <dsound.h>
#include <stdio.h>

class				AudioOutput
{
/*
 -----------------------------------------------------------------------------------------------------------------------
 -----------------------------------------------------------------------------------------------------------------------
 */
public:
	AudioOutput(int _iFrequency, int _iBytesPerSample, double _fBufferLength, char *_szOutputFileName, int _iOutputDevice);
	~				AudioOutput();
	static void		vListAudioDevices();
	void			vRender(double _fSample);
	int				iFrequency();
	void			vStop();
	void			vPlay();
	unsigned int	m_uiWritten;

/*
 -----------------------------------------------------------------------------------------------------------------------
 -----------------------------------------------------------------------------------------------------------------------
 */
private:
	LPDIRECTSOUND			m_poDirectSound;
	LPDIRECTSOUNDBUFFER		m_poPrimaryBuffer;
	LPDIRECTSOUNDBUFFER		m_poStreamBuffer;
	int						m_iFrequency;

	/* Positions and sizes below are expressed in bytes */
	char					*m_pcHWBuffer;
	int						m_iHWBufferSize;
	int						m_iHWBytesAvailable;
	int						m_iHWPreviousBytesAvailable;
	int						m_iHWPosition;

	FILE					*m_poOutputFile;

	bool					m_bDeviceFound;
	int						m_iDesiredDeviceIndex;
	int						m_iBytesPerSample;
	LPGUID					m_poDesiredDeviceGUID;
	static BOOL CALLBACK	bEnumerateCallback(LPGUID lpGUID, LPCTSTR lpszDesc, LPCTSTR lpszDrvName, LPVOID lpContext);
};
#endif
