
	PUBLIC	vGetString
	PUBLIC	vSaveMemoryConfig
	PUBLIC	vRestoreMemoryConfig

	EXTERN	DOS_call
	EXTERN	PUT_P4000
	EXTERN	GET_P4000
	EXTERN	PUT_P8000
	EXTERN	GET_P8000

;******************************************************************************
	RSEG	code
;******************************************************************************

vGetString:	push	bc
	ld	c,0xA
	call	DOS_call
	pop	bc
	ret

;******************************************************************************
;******************************************************************************

vSaveMemoryConfig:	call	GET_P4000
	ld	(previousSegment4),a
	call	GET_P8000
	ld	(previousSegment8),a

	ld	a,(0xF342)
	ld	(previousSlot),a

	ret

;******************************************************************************
;******************************************************************************

vRestoreMemoryConfig:	push	de
	push	bc
	push	ix
	push	iy
	
	ld	a,(previousSlot)
	ld	(0xF342),a
	ld	h,0x40
	call	0x24

	ld	a,(previousSegment4)
	call	PUT_P4000
	ld	a,(previousSegment8)
	call	PUT_P8000

	pop	iy
	pop	ix
	pop	bc
	pop	de
	ret

;******************************************************************************
	RSEG	bss
;******************************************************************************

previousSegment4:	defb	0
previousSegment8:	defb	0
previousSlot:	defb	0


	END
