#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>

#include "utils.h"

/*
 =======================================================================================================================
 =======================================================================================================================
 */
long atoin(char *_pcString, char _cLength)
{
	/*~~~~~~~~~~~~~~~~~~~~~~*/
	unsigned long	ulResult;
	bool			bNegative;
	/*~~~~~~~~~~~~~~~~~~~~~~*/

	ulResult = 0;
	bNegative = false;

	if(_cLength)
	{
		if(*_pcString == '-')
		{
			_cLength--;
			_pcString++;
			bNegative = true;
		}
		else if(*_pcString == '+')
		{
			_cLength--;
			_pcString++;
		}
	}

	while((_cLength--) && (*_pcString >= '0') && (*_pcString <= '9'))
	{
		ulResult *= 10;
		ulResult += (*_pcString++) - '0';
	}

	return bNegative ? (-ulResult) : ulResult;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
FILE *poOpenFileWithCheck(char *_szFileName, char *_szMode)
{
	/*~~~~~~~~~~~~*/
	FILE	*poFile;
	/*~~~~~~~~~~~~*/

	poFile = fopen(_szFileName, _szMode);
	if(!poFile) vWarning("Unable to open ", _szFileName);

	return poFile;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
char * szFixFileName(char *_szFileName)
{
	/*~~~~~~~~~~~~~~~~~~~~~~*/
	char	*pcC;
	char	*pcLastDot = NULL;
	char	*szResult;
	/*~~~~~~~~~~~~~~~~~~~~~~*/

	szResult = strdup(_szFileName);

	for(pcC = szResult; *pcC; pcC++)
	{
		switch(*pcC)
		{
		case ',':
		case ' ':
		case '+':
		case '*':
		case '?':
			*pcC = '_';
			break;

		case '[':
			*pcC = '(';
			break;

		case ']':
			*pcC = ')';
			break;

		case '.':
			if(pcLastDot)
			{
				*pcLastDot = '_';
			}

			pcLastDot = pcC;
			break;

		case '/':
			*pcC = '\\';
			pcLastDot = NULL;
			break;

		case '\\':
			pcLastDot = NULL;
			break;
		}
	}

	return szResult;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void vDisplayPercentage(unsigned char _ucPercentage)
{
	/*~~~~~~~~~~~~~~~~~~~~*/
	char	acPercentage[4];
	char	cLength;
	/*~~~~~~~~~~~~~~~~~~~~*/

	utoa(_ucPercentage, acPercentage, 10);

	putch(' ');
	cputs(acPercentage);
	putch('%');
	cLength = strlen(acPercentage) + 2;

	while(cLength--) putch(29);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void vPrintDec(int _iV, char _cSize)
{
	/*~~~~~~~~~~~~~~~~~*/
	char	acBuffer[11];
	/*~~~~~~~~~~~~~~~~~*/

	itoan(_iV, acBuffer, 10, _cSize);
	cputs(acBuffer);
}


char cDaysInAMonth(int _iYear, char _iMonth)
{
	switch(_iMonth)
	{
	case 4:
	case 6:
	case 9:
	case 11:
		return 30;

	case 2:
		return(((_iYear % 4 == 0) && (_iYear % 100 != 0)) || (_iYear % 400 == 0)) ? 29 : 28;

	default:
		return 31;
	}
}
