	PUBLIC	UNAPI_bInit

	PUBLIC	TCP_eStartHostNameQuery
	PUBLIC	TCP_eOpen
	PUBLIC	TCP_eSend
	PUBLIC	TCP_eClose
	PUBLIC	TCP_eReceive
	PUBLIC	TCP_eObtainHostNameResolutionResult
	PUBLIC	TCP_eGetOutputBufferFreeBytes
	PUBLIC	TCP_eWait
		
	EXTERN	DOS_call
	EXTERN	PUT_P4000
	EXTERN	GET_P4000
	EXTERN	?ENT_PARM_DIRECT_L09
	EXTERN	?LEAVE_DIRECT_L09

;******************************************************************************
	RSEG	code
;******************************************************************************

TCPIP_GET_CAPAB	equ	1
TCPIP_GET_IPINFO	equ	2
TCPIP_NET_STATE	equ	3
TCPIP_DNS_Q	equ	6
TCPIP_DNS_S	equ	7
TCPIP_TCP_OPEN	equ	13
TCPIP_TCP_CLOSE	equ	14
TCPIP_TCP_ABORT	equ	15
TCPIP_TCP_STATE	equ	16
TCPIP_TCP_SEND	equ	17
TCPIP_TCP_RCV	equ	18
TCPIP_WAIT	equ	29

EXTBIO	equ	0xFFCA
ARG	equ	0xF847

;******************************************************************************
;******************************************************************************

slot:	defb	0
segment:	defb	0
previousSegment:	defb	0

UNAPI_bInit:	push	de
	push	bc
	push	ix
	push	iy

	ld	hl,TCPIP_S
	ld	de,ARG
	ld	bc,15
	ldir

	xor	a
	ld	b,0
	ld	de,0x2222
	call	EXTBIO
	ld	a,b
	or	a
	jr	z,notFound

	ld	a,1
	ld	de,0x2222
	call	EXTBIO

	ld	(entry),hl

	ld	(slot),a
	ld	a,b
	ld	(segment),a

	ld	a,1

notFound:	pop	iy
	pop	ix
	pop	bc
	pop	de

	ret

;******************************************************************************
;******************************************************************************

setSlot:	push	ix
	push	iy
	push	af
	push	hl
	push	bc
	push	de

	call	GET_P4000
	ld	(previousSegment),a

	ld	a,(slot)
	ld	h,0x40
	call	0x24

	ld	a,(segment)
	cp	0xFF
	call	nz,PUT_P4000
	

	pop	de
	pop	bc
	pop	hl
	pop	af
	pop	iy
	pop	ix
	ret

;******************************************************************************
;******************************************************************************


unsetSlot:	push	ix
	push	iy
	push	af
	push	hl
	push	bc
	push	de

	ld	a,(0xF342)
	ld	h,0x40
	call	0x24
	
	ld	a,(previousSegment)
	call	PUT_P4000


	pop	de
	pop	bc
	pop	hl
	pop	af
	pop	iy
	pop	ix
	ret


;******************************************************************************
;******************************************************************************

UNAPI:	call	setSlot

	push	iy
	call	0
entry	equ	$-2
	pop	iy
	
	call	unsetSlot
	ret

;******************************************************************************
;******************************************************************************

TCP_eStartHostNameQuery:	call	?ENT_PARM_DIRECT_L09

	push	iy
	
	ld	h,d
	ld	l,e
	ld	b,c
	ld	a,TCPIP_DNS_Q
	
	push	ix
	call	UNAPI
	pop	ix
	
	push	hl
	ld	l,(ix+10)
	ld	h,(ix+11)
	push	hl
	pop	iy
	pop	hl
	
	ld	(iy+0),l
	ld	(iy+1),h
	ld	(iy+2),e
	ld	(iy+3),d

	ld	L,(ix+8)
	ld	H,(ix+9)
	ld	(hl),b

	pop	iy

	jp	?LEAVE_DIRECT_L09

;******************************************************************************
;******************************************************************************

TCP_eWait:	push	bc
	push	de
	push	ix

	ld	a,29
	call	UNAPI

	ld	c,0x0B
	call	DOS_call

	pop	ix
	pop	de
	pop	bc
	ret

;******************************************************************************
;******************************************************************************

TCP_eGetOutputBufferFreeBytes:
	push	ix
	push	iy

	push	bc

	ld	a,16
	ld	b,e
	ld	hl,0
	call	UNAPI
	
	push	ix
	pop	hl

	pop	iy
	ld	(iy+0),l
	ld	(iy+1),h

	pop	iy	
	pop	ix
	ret

;******************************************************************************
;******************************************************************************

TCP_eObtainHostNameResolutionResult:

	call	?ENT_PARM_DIRECT_L09

	push	iy

	push	bc
	ld	b,e
	ld	a,TCPIP_DNS_S
	push	ix
	call	UNAPI
	pop	ix
	pop	iy
	ld	(iy+0),b
	
	push	hl
	ld	l,(ix+10)
	ld	h,(ix+11)
	push	hl
	pop	iy
	pop	hl
	
	ld	(iy+0),l
	ld	(iy+1),h
	ld	(iy+2),e
	ld	(iy+3),d

	ld	l,(ix+8)
	ld	h,(ix+9)
	ld	(hl),c

	pop	iy

	jp	?LEAVE_DIRECT_L09

;******************************************************************************
;******************************************************************************

TCP_eOpen:
	push	bc

	ld	h,d
	ld	l,e
	ld	a,13

	push	ix
	call	UNAPI
	pop	ix

	pop	hl
	ld	(hl),b

	ret

;******************************************************************************
;******************************************************************************

TCP_eClose:	push	bc
	ld	b,e
	ld	a,14
	push	ix
	call	UNAPI
	pop	ix
	pop	bc
	ret

;******************************************************************************
;******************************************************************************

TCP_eSend:
	call	?ENT_PARM_DIRECT_L09

	ld	l,e

	ld	d,b
	ld	e,c

	ld	b,l

	ld	l,(ix+8)
	ld	h,(ix+9)
	ld	c,(ix+10)
	
	ld	a,17
	push	ix
	call	UNAPI
	pop	ix

	jp	?LEAVE_DIRECT_L09

;******************************************************************************
;******************************************************************************

TCP_eReceive:
	call	?ENT_PARM_DIRECT_L09

	ld	l,e
	ld	d,b
	ld	e,c
	
	ld	b,l
	ld	l,(ix+8)
	ld	h,(ix+9)
	
	ld	a,18
	push	ix
	call	UNAPI
	pop	ix
	
	push	hl
	ld	l,(ix+10)
	ld	h,(ix+11)
	ld	(hl),c
	inc	hl
	ld	(hl),b
	pop	hl
	
	ld	b,h
	ld	c,l
	ld	l,(ix+12)
	ld	h,(ix+13)
	ld	(hl),c
	inc	hl
	ld	(hl),b
	
	jp	?LEAVE_DIRECT_L09

;******************************************************************************
	RSEG	data
;******************************************************************************

TCPIP_S:	defm	"TCP/IP"

	END
