#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

#include "unapi.h"
#include "utils.h"

typedef struct
{
	unsigned char	m_aucIPAddress[4];
	unsigned int	m_uiRemotePort;
	unsigned int	m_uiLocalPort;
	unsigned int	m_uiSuggestionForUserTimeOutValue;
	unsigned char	m_ucFlags;
} tdParameterBlock;

typedef enum
{
	ERR_OK			= 0,
	ERR_NOT_IMP,
	ERR_NO_NETWORK,
	ERR_NO_DATA,
	ERR_INV_PARAM,
	ERR_QUERY_EXISTS,
	ERR_INV_IP,
	ERR_NO_DNS,
	ERR_DNS,
	ERR_NO_FREE_CONN,
	ERR_CONN_EXISTS,
	ERR_NO_CONN,
	ERR_CONN_STATE,
	ERR_BUFFER,
	ERR_LARGE_DGRAM,
	ERR_INV_OPER
} tdErrorCode;

char		*g_acErrorMessages[] =
{
	"", "Capability not implemented", "No network connection available",
	"No incoming data available", "Invalid input parameter",
	"Another query is already in progress", "Invalid IP address", "No DNS servers are configured",
	"Error returned by DNS server", "No free connections available", "Connection already exists",
	"Connection does not exist", "Invalid connection state", "Insufficient output buffer space",
	"Datagram is too large", "Invalid operation"
};

tdErrorCode TCP_eWait();

tdErrorCode TCP_eGetOutputBufferFreeBytes(unsigned char _ucConnectionNumber, unsigned int *_puiFreeBytes);

tdErrorCode TCP_eOpen(tdParameterBlock *_poParameterBlock, unsigned char *_pucConnectionNumber);

tdErrorCode TCP_eClose(unsigned char _ucConnectionNumber);

tdErrorCode TCP_eStartHostNameQuery
			(
				char			*_szHostName,
				unsigned char	_ucFlags,
				unsigned char	*_pucResult,
				unsigned char	*_pucIPAddress
			);

tdErrorCode TCP_eObtainHostNameResolutionResult
			(
				unsigned char	_ucFlags,
				unsigned char	*_pucResult,
				unsigned char	*_pucSubResult,
				unsigned char	*_pucIPAddress
			);

tdErrorCode TCP_eSend(unsigned char _ucConnectionNumber, char *_pcData, unsigned int _uiLength, unsigned char _ucFlags);

tdErrorCode TCP_eReceive
			(
				unsigned char	_ucConnectionNumber,
				char			*_pcData,
				unsigned int	_uiLength,
				unsigned int	*_puiTotalBytesReceived,
				unsigned int	*_puiUrgentBytesReceived
			);

/*
 =======================================================================================================================
 =======================================================================================================================
 */
tdErrorCode eCheck(tdErrorCode _eErrorCode)
{
	if(_eErrorCode) vWarning("UNAPI: ", g_acErrorMessages[_eErrorCode]);
	return _eErrorCode;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
unsigned char UNAPI_ucConnectToHostName(unsigned int _uiPort, char *_szHostName)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	unsigned char	ucResult;
	unsigned char	ucSubResult;
	unsigned char	aucIPAddress[4];
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	TCP_eWait();

	TCP_eStartHostNameQuery(_szHostName, 0, &ucResult, aucIPAddress);
	TCP_eObtainHostNameResolutionResult(1, &ucResult, &ucSubResult, aucIPAddress);

	if(ucResult == 2)
		return UNAPI_ucConnectToIPAddress(_uiPort, aucIPAddress);
	else
		return 0;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
unsigned char UNAPI_ucConnectToIPAddress(unsigned int _uiPort, unsigned char *_aucIPAddress)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	unsigned char		ucConnection;
	tdParameterBlock	oURI;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	TCP_eWait();

	oURI.m_uiRemotePort = _uiPort;
	oURI.m_uiLocalPort = 0xFFFF;
	oURI.m_uiSuggestionForUserTimeOutValue = 0xFFFF;
	oURI.m_ucFlags = 0;
	memcpy(oURI.m_aucIPAddress, _aucIPAddress, 4);

	eCheck(TCP_eOpen(&oURI, &ucConnection));

	return ucConnection;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void UNAPI_vCloseTCPConnection(char _cConnection)
{
	TCP_eWait();

	eCheck(TCP_eClose(_cConnection));
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void UNAPI_vReceiveWithCheck(int _iMaxSize, char *_pcBuffer, char _cConnection, unsigned int *_piBytesRead)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
	unsigned int	uiUrgentBytesRead;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

	TCP_eWait();

	*_piBytesRead = 0;
	if(eCheck(TCP_eReceive(_cConnection, _pcBuffer, _iMaxSize, _piBytesRead, &uiUrgentBytesRead)))
	{
		vError("Network read command error", NULL);
	}
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
unsigned int UNAPI_uiSendWithCheck(char _cConnection, char *_pcBuffer, unsigned int _uiSize)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/
	unsigned int	uiSizeToSend;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/

	TCP_eWait();

	eCheck(TCP_eGetOutputBufferFreeBytes(_cConnection, &uiSizeToSend));

	if(uiSizeToSend)
	{
		if(uiSizeToSend > _uiSize) uiSizeToSend = _uiSize;
	
		if(eCheck(TCP_eSend(_cConnection, _pcBuffer, uiSizeToSend, 0)) == ERR_BUFFER)
		{
			uiSizeToSend = 0;
		}
	}

	return uiSizeToSend;
}
