#include <common.inc>

#define PUBLISH
#include "seg.inc"

EXTBIO	equ 0xFFCA

;******************************************************************************
	RSEG code
;******************************************************************************

SEG_bInit:	push	bc
	push	de
	push	ix
	push	iy

	ld	a,(0xFB20)	; Check if there is extended bios
	bit	0,a
	jr	z,fail

	ld	c,0x6F	; Check for a dos2 kernel
	call	0x0005
	ld	a,c
	cp	0x6F
	jr	z,fail

	xor	a
	ld	d,4
	ld	e,2
	ld	hl,-1
	call	EXTBIO

	ld	a,h
	and	l
	inc	a
	jr	z,fail
	
	ld	bc,JUMP_TABLE_END-JUMP_TABLE_START
	ld	de,JUMP_TABLE_START
	ldir

	ld	a,0
	jr	ok

fail:	ld	a,1

ok:	pop	iy
	pop	ix
	pop	de
	pop	bc
	ret

;******************************************************************************
;******************************************************************************

SEG_bAllSeg:	push	bc
	xor	a
	ld	b,a
	call	ALL_SEG
	ld	(de),a
	pop	bc
	ld	a,0
	ret	c
	inc	a
	ret

;******************************************************************************
;******************************************************************************

SEG_vFreeSeg:	push	bc
	ld	a,e
	ld	b,0
	call	FRE_SEG
	pop	bc
	ret

;******************************************************************************
;******************************************************************************

SEG_vSetP4000:	ld	a,e
	jp	PUT_P4000

;******************************************************************************
;******************************************************************************

SEG_vSetP8000:	ld	a,e
	jp	PUT_P8000

;******************************************************************************
;******************************************************************************

SEG_ucGetP4000	equ	GET_P4000

;******************************************************************************
;******************************************************************************

SEG_ucGetP8000	equ	GET_P8000

;******************************************************************************
;******************************************************************************

JUMP_TABLE_START:

ALL_SEG:	defb	0,0,0	; Allocate a 16k segment.	                         
FRE_SEG:	defb	0,0,0	; Free a 16k segment.	                             
RD_SEG:	defb	0,0,0	; Read byte from address A:HL to A.	               
WR_SEG:	defb	0,0,0	; Write byte from E to address A:HL.	              
CAL_SEG:	defb	0,0,0	; Inter-segment call.  Address in IYh:IX	          
CALLS:	defb	0,0,0	; Inter-segment call.  Address in line after the call instruction.               
PUT_PH:	defb	0,0,0	; Put segment into page (HL).	                     
GET_PH:	defb	0,0,0	; Get current segment for page (HL)	               
PUT_P0000:	defb	0,0,0	; Put segment into page 0.	                        
GET_P0000:	defb	0,0,0	; Get current segment for page 0.	                 
PUT_P4000:	defb	0,0,0	; Put segment into page 1.	                        
GET_P4000:	defb	0,0,0	; Get current segment for page 1.	                 
PUT_P8000:	defb	0,0,0	; Put segment into page 2.	                        
GET_P8000:	defb	0,0,0	; Get current segment for page 2.	                 
PUT_PC000:	defb	0,0,0	; Not supported since page-3 must never be changed.  Acts like a "NOP" if called.
GET_PC000:	defb	0,0,0	; Get current segment for page 3.	                 

JUMP_TABLE_END:

;******************************************************************************
;******************************************************************************

	END
