#include "gr8net.inc"
	PUBLIC	GR8NET_bInit

	PUBLIC	tcpest
	PUBLIC	sclose
	PUBLIC	rx
	PUBLIC	tx
	PUBLIC	netcmd
	PUBLIC	wait

	EXTERN	?ENT_PARM_DIRECT_L09
	EXTERN	?LEAVE_DIRECT_L09
	EXTERN	DOS_call

;******************************************************************************
	RSEG	lowcode
;******************************************************************************

slot:	defb	0

setSlot:	push	ix
	push	iy
	push	af
	push	hl
	push	bc
	push	de
	ld	a,(slot)
	ld	h,0x40
	call	0x24
	pop	de
	pop	bc
	pop	hl
	pop	af
	pop	iy
	pop	ix
	ret
	
	
unsetSlot:	push	ix
	push	iy
	push	af
	push	hl
	push	bc
	push	de
	ld	a,(0xF342)
	ld	h,0x40
	call	0x24
	pop	de
	pop	bc
	pop	hl
	pop	af
	pop	iy
	pop	ix
	ret


GR8NET_bInit:	xor	a
	out	(05Eh),a
	in	a,(05Fh)
	cp	'G'
	ld	a,0
	ret	nz
	
found:	ld	a,1
	out	(05Eh),a

	in	a,(05Fh)
	ld	(slot),a

	ld	a,1
	ret

;******************************************************************************
;******************************************************************************

tcpest:	push	ix
	push	iy

	ld	a,e
	call	setSlot
	call	C_B2ON
	call	C_TCPEST
	call	C_B2OFF
	call	unsetSlot

	ld	a,0
	adc	a,0

	pop	iy
	pop	ix
	ret

;******************************************************************************
;******************************************************************************

rx:	call	?ENT_PARM_DIRECT_L09

	ld	a,(ix+8)
	ld	h,b
	ld	l,c

	push	ix
	push	iy
	call	setSlot
	call	C_B2ON
	call	C_RX
	call	C_B2OFF
	call	unsetSlot
	pop	iy
	pop	ix

	ld	a,1
	jr	nz,dataReceived

	dec	a
	ld	bc,0

dataReceived:	ld	l,(ix+10)
	ld	h,(ix+11)

	ld	(hl),c
	inc	hl
	ld	(hl),b

	jp	?LEAVE_DIRECT_L09

;******************************************************************************
;******************************************************************************

tx:	call	?ENT_PARM_DIRECT_L09
	push	ix
	push	iy

	ld	a,(ix+8)
	ld	h,b
	ld	l,c

	call	setSlot
	call	C_B2ON
	call	C_TX
	call	C_B2OFF
	call	unsetSlot
	
	ld	a,0xFF
	adc	a,0

	pop	iy
	pop	ix
	jp	?LEAVE_DIRECT_L09

;******************************************************************************
;******************************************************************************

netcmd:	push	ix
	push	iy

	ld	a,c
	or	a
	jr	z,read1
	scf

read1:	ld	a,e
	call	setSlot
	call	C_B2ON
	call	C_NETCMD
	call	C_B2OFF
	call	unsetSlot

	ld	a,0
	adc	a,0

	pop	iy
	pop	ix
	ret
	
;******************************************************************************
;******************************************************************************

sclose:	push	bc
	push	ix
	push	iy

	ld	a,e
	call	setSlot
	call	C_B2ON
	call	C_SCLOSE
	call	C_B2OFF
	call	unsetSlot

	pop	iy
	pop	ix
	pop	bc
	ret

;******************************************************************************
;******************************************************************************

wait:	push	bc
	push	de
	
	ld	c,0x0B
	call	DOS_call
	
	pop	de
	pop	bc
	ret

;******************************************************************************
;******************************************************************************

	END
