;********************************************************************************
;*										*
;* ROM for the GR8NET internetworking card					*
;* Developed 2009-2017 by Eugeny Brychkov		http://www.gr8bit.ru	*
;*										*
;* Header file, build 20170421							*
;*										*
;********************************************************************************

; Memory layout for GR8NET device
;	4000-5FFF	ROM page 0 (boot, always should be in place)
;	6000-7FFF	RAM page, switchable (rampg/pgram), max CFGAPG pages
;	8000-9FFF	ROM pages, switchable (rompg/pgrom), max CFGOPG pages
;	A000-BFFF	LAN chip pages, switchable (lanpg/pglan), max 4 pages

; Special register set definition
SDCINI	equ	05FC0h		; SD-card initialization register
SDCPOS	equ	05FC1h		; buffer position
SDCSC0	equ	05FC2h		; 32-bit sector address
SDCSC1	equ	05FC3h
SDCSC2	equ	05FC4h
SDCSC3	equ	05FC5h
SDCSCN	equ	05FC6h		; sector count + check pattern 1
SDCCMD	equ	05FC7h		; command + check pattern 2
SDCSIZ	equ	05FCCh		; size of the SD-card in 512-byte sectors

B0CHG	equ	05FE0h		; bank 0 change address (RAM)
B1CHG	equ	05FE1h		; bank 1 change address (RAM)
B2CHG	equ	05FE2h		; bank 2 change address (ROM)
B3CHG	equ	05FE3h		; bank 3 change address (LAN)
MYSLT	equ	05FE4h		; my adapter slot ID in RDSLT format, 0 after reset
B2SLT	equ	05FE5h		; preserve space for bank 2 slot ID
SNDVOL	equ	05FE6h		; sound volumes: master, SCC, digital wave, PCM
IGREG	equ	05feah			; controlled interrupt generator registers
IGCTR0	equ	05febh
IGCTR1	equ	05fech
IGCTR2	equ	05fedh
WAVEIN	equ	05feeh			; wave input register
PCMCTR	equ	05ff0h			; PCM function registers
PCMFRE	equ	05ff1h
PCMWRI	equ	05ff3h
PCMDR	equ	05ff5h
PREFRG	equ	05ff7h			; Prefetch function registers
PREFSL	equ	05ff8h
PREFEL	equ	05ffah
PREFH	equ	05ffch
PREFDT	equ	05ffdh
NETMOD	equ	05FFFh		; network mode byte

ADRPRT	equ	05eh		; addressing I/O port, previously was 10h
DATPRT	equ	05fh		; data I/O port, previously was 11h

ADAPID	equ	05FDFh		; adapter ID, 7:6 and 5:4 is adapter # (read only)
MAPID	equ	05FDEh		; mapper type, same as visible through I/O
P10DATA	equ	05FDDh		; port 10h value
ERRREG	equ	05FDCh		; error code storage register, bit 7 resets value
MMRFLG	equ	05FDBh		; memory mapper value read flag (bit 0), SCC frequency (bit 1),
				; OPLL disable (bit 2), OPLL amplitude double (bit 3)
OPLVOL	equ	05FDAh		; OPLL volume
AUDSTP	equ	05FD8h		; MSX-Audio (Y8950) ADPCM RAM starting page
AUDSIZ	equ	05FD9h		; MSX-Audio (Y8950) ADPCM RAM size in 8kB pages

; Configuration page layout: page #CFGAPG
;	6000-6BFF	(3K) Card configuration data
;	6C00-6FFF	(1K) Packet send buffer
;	7000-77FF	(2K) Confirmed received packet buffer
;	7800-7FFF	(2K) Temporary buffer for received packets
RAMBASE	equ	06000h		; RAM base address, its LSB should be 0
P_SEND	equ	06c00h		; packet to send base address in RAM
P_RECV	equ	07000h		; received packet base address in RAM
P_TEMP	equ	07800h		; temporary receive storage in RAM
P_SCSA	equ	07bc8h		; space to save screen image for browser (8000h-27d*40d)
P_SIZE	equ	0800h		; maximal UDP packet size (can not be larger than
				; P_TEMP storage areas where packet is being loaded)

; LAN/W5100 properties
LANBASE	equ	0a000h		; LAN base address
WRMSRV	equ	055h		; two sockets - 0  and 1 with 4K buffers each
WM_SOC	equ	07ffh		; socket memory space mask (2k)

; LAN/W5100 interrupt registers
IRMASK	equ	00h		; no interrupts (all disabled)									;3h		; mask for W_IR register - turn interrupts from S1 and S0 on
SIRMASK	equ	04h		; mask for socket IR registers - enable interrupt from receive only
MAXSOCK	equ	02h		; number of configured sockets - 2

devid	equ	9		; device ID

; Logical page assignments
RAMST	equ	0h		; RAM page sequence start
CFGAPG	equ	0ffh		; RAM page for configuration information
RAMMASK	equ	07fh		; mask for RAM page number
RAMOVRF	equ	080h		; RAM page number overflow
ROM0PG	equ	080h		; first ROM pahe to appear in bank 0
CFGOPG	equ	0bfh		; ROM page for configuration information
OPLLRP	equ	0b6h		; starting OPLL ROM page (2 GR8NET pages)
LANRPG	equ	0c0h		; LAN chip registers page
LANTXPG	equ	0c2h		; LAN chip TX buffers
LANRXPG	equ	0c3h		; LAN chip RX buffers
SDCDPG	equ	0c8h		; SD-card data page
MATHPG	equ	0c9h		; Mathpack page

; --- MathPack definitions
VSTLBA	equ	024h			; Volume starting LBA (4)
SPERCL	equ	020h			; sectors per cluster (1)
NOFFAT	equ	023h			; number of FATs (1)
SECPFAT	equ	028h			; sectors per FAT (4)
RESSEC	equ	021h			; number of reserved sectors (2)
CLUNUM	equ	038h			; cluster number
FSTYP	equ	046h			; file system type, FAT32/FAT16
CLUSEC	equ	03ch			; first sector of the cluster
CLUFAT	equ	040h			; FAT sector of the next cluster
CLUOFF	equ	044h			; offset in FAT sector

; --- ROM BIOS call addresses
RDSLT	equ	000CH
WRSLT	equ	0014H
CALSLT	equ	001CH		; inter-slot call routine
CHPUT	equ	00A2H		; put a character to console
ENASLT	equ	0024h		; switch page for bank specified in H bits 7 and 6
BREAKX	equ	00B7h		; tests for CTRL-STOP press. Returns CY set is pressed
CHSNS	equ	009Ch		; checks keyboard buffer for char waiting. ZF=1 is empty
CHGET	equ	009Fh		; gets character. If buffer is empty, waits for input
KILBUF	equ	0156h		; clear keyboard buffer
INITXT	equ	006Ch		; set screen mode to SCREEN0
ERAFNK	equ	00CCh		; erase function key display from the screen
CALBAS	equ	00159H		; call to BASIC interpreter
SETTXT	equ	0078h

; --- ROM BIOS variables
ROMSLT	equ	0FFF7h		; slot address of main-ROM
PROCNM  EQU     0FD89H          ; indicates statement name or device name
EXPTBL  EQU     0FCC1H          ; indicates which slot is expanded
LINLEN	EQU	0F3B0H		; Current screen width per line
CSRX	equ	0F3DDh		; X-coordinate of text cursor
VALTYP	equ	0f663h		; Contains the code of the type of variable that is currently in DAC
DAC	equ	0F7F6h		; Decimal accumulator
STRTYP	equ	03h		; string value
INTTYP	equ	02h		; word value
SGLTYP	equ	04h		; single precision floating-point value
DBLTYP	equ	08h		; double precision floating-point value
PTRFIL	equ	0F864h		; Points to file data of currently accessing file
FILTAB	equ	0F860h		; Starting address of of file data area
MAXFIL	equ	0F85Fh		; Maximal allowed file number
FILNAM	equ	0F866h		; Name for FILES, NAME & others
EXTBIO	equ	0FFCAh		; EXTBIO call hook
HOKVLD	equ	0FB20h		; bit 0 is set if EXTBIO hook is valid
RAMAD1	equ	0F342H		; slotid DOS ram page 1
RAMAD2	equ	0F343H		; slotid DOS ram page 2

; --- Errors jump addresses
FCERR   EQU     475AH           ; entry of 'Illegal function call'
SNERR   EQU     4055H           ; entry of 'Syntax error'
DIOERR  EQU     73B2H           ; entry of 'Device I/O error'
MISSOP	equ	406AH		; entry of 'Missing operand'
BADFN	equ	6E6BH		; entry of 'Bad file name'
ERRHA	equ	0406fh		; Error handler, error code is in E

; --- BASIC routines
GETBYT  EQU     521CH           ; evaluate/get 8 bit unsigned integer
FRMQNT	equ	542FH		; evaluate/get 16 bit unsigned integer
PTRGET	equ	05ea4h		; Obtain the address for the storage of a variable
CNVVAL	equ	0517ah		; Convert DAC value to specified numeric type
FRMEVL	equ	04c64h		; Evaluate an expression in text, for string push
				; string into string stack/DAC
				; returns HL=ptr to string descriptor
NEWSTT	equ	04601h		; Execute BASIC text
FRESTR	equ	067d0h		; Free string storage area
MAKSTR	equ	06611h		; Create new string

; ---- W5100 register configuration ----
; mode
W_MR	equ	0h		; mode register
W_RTR	equ	017h		; [2] retry register
W_RCR	equ	019h		; retry count register

; interrupts
W_IR	equ	015h		; interrupt register
W_IMR	equ	016h		; interrupt mask register
W_S0_IR	equ	0402h		; interrupt status registers for all 4 sockets
W_S1_IR	equ	0502h
W_S2_IR	equ	0602h
W_S3_IR	equ	0702h

; operating registers
W_GAR	equ	01h
W_SUBR	equ	05h
W_SHAR	equ	09h
W_SIPR	equ	0fh

; sockets registers
W_RMSR	equ	01ah
W_TMSR	equ	01bh

; socket registers (offset from their base)
WS_MR	equ	00h		; socket mode register
WS_CR	equ	01h		; socket command register
WS_IR	equ	02h		; socket interrupt register
WS_SR	equ	03h		; socket status register
WS_SP	equ	04h		; socket source port (2 bytes)
WS_DH	equ	06h		; socket destination hardware address (6 bytes)
WS_DR	equ	0ch		; socket destination IP address (4 bytes)
WS_DP	equ	010h		; socket destination port (2 bytes)
WS_MS	equ	012h		; socket maximum segment size (2 bytes)
WS_RRD	equ	028h		; socket RX read pointer
WS_RSR	equ	026h		; socket received size
WS_TFS	equ	020h		; socket TX free size
WS_TWR	equ	024h		; socket TX write pointer
WS_MSS	equ	012h

; W5100 commands
C_SEND	equ	020h		; transmit data using incremented TX write pointer
C_OPEN	equ	01h		; initialize socket
C_CLOSE	equ	010h		; close socket
C_RECV	equ	040h		; start receiving for the socket
C_CONN	equ	04h		; connect request
C_LIST	equ	02h		; listen command
C_DISC	equ	08h		; disconnect command

; W5100 modes
M_TCP	equ	01h		; TCP mode for master register
M_NDACK	equ	020h		; No delayed ACK

; W5100 status values
S_SUDP	equ	022h		; socket is open in UDP mode
S_INIT	equ	013h		; socket is open for TCP mode
S_ESTA	equ	017h		; socket's connection establiished status
S_LIST	equ	014h		; socket is listening

; W5100 bits
WB_TOU	equ	08h		; timeout bit of the socket interrupt register
WB_RCV	equ	04h		; data received bit
WB_DIS	equ	02h		; disconnected bit

; packet sizes
DHCPLEN	equ	548d		; DHCP packet length
MAXUDPS	equ	1792d		; maximal length for UDP packet

; ports
PDHCPD	equ	067d		; destination (server) port for DHCP
PDHCPS	equ	068d		; source (my) port for DHCP
PDNS	equ	053d		; DNS service port - at both my and server ends
PNTP	equ	0123d		; NTP service port - both ends
DUMPRT	equ	0c000h		; starting source port #

; ROM layout definitions
STAPG	equ	082h		; ROM page statement processing is located in
HLPPG0	equ	083h		; ROM page 0 helper routines are located in
HLPPG1	equ	084h		; ROM page 1 helper routines are located in
HLPPG2	equ	087h		; ROM page 2 helper routines are located in
ERRCLR	equ	040h		; bit 6 will be set in the HLPPG* definition in statement processing to identify routines
				; which require ERRREG to be reset before processing statement
RPAGE1	equ	081h
BRWSPG	equ	085h		; web browser ROM page
SDCPG	equ	086h		; SD-card routines' page
ERHSPG	equ	087h		; Error and HTTP code strings page
FLSHPG	equ	087h		; Page containing reflash code
NCFGPG	equ	087h		; adapter configuration routine page

SRVSLN	equ	32d		; length of server string
PATHLN	equ	240d		; length of path string
FNAMLN	equ	64d		; length of URI file name string
QUESLN	equ	64d		; query string length
DIMLEN	equ	240d		; disk image URI length, should be less than 251!

MAPSET	equ	0f55eh		; RAM location for mapper change operations. 0F55E points
				; to keyboard buffer

IS720K	equ	05ah		; 720K image size in pages
IS360K	equ	02dh		; 360K image size in pages
HRAMOVF	equ	040h		; RAM top for half of RAM

; definition of I/O register indexes
IOCHK	equ	0h		; check register, 'G'
IOSLTI	equ	01h		; slot ID
IOMAPI	equ	02h		; mapper type

; socket allocation
SUSOCK	equ	02h		; system used UDP socket - DHCP, DNS
SUSORB	equ	0a600h
SUSOBB	equ	0b000h
STSOCK	equ	03h		; system used TCP socket - BLOAD etc
STSORB	equ	0a700h		; system used TCP socket register base
STSOBB	equ	0b800h		; system used TCP socket data base
S3TX	equ	05800h		; W5100 absolute address of TX memory for socket 3 (used for prefetch)
S3RX	equ	07800h		; W5100 absolute address of RX memory for socket 3 (used for prefetch)

; remote resource structure
RESFLG	equ	0		; [1] resolution flag offset 0
HNAMEP	equ	RESFLG+1	; [32] host name offset
RESADR	equ	HNAMEP+SRVSLN	; [4] resolved IP address of the hist name above
DESPRT	equ	RESADR+4	; [2] destination port
SRCPRT	equ	DESPRT+2	; [2] source port
PATHPP	equ	SRCPRT+2	; [240] path position
FNAMEP	equ	PATHPP+PATHLN	; [64] file name position
QUESTP	equ	FNAMEP+FNAMLN	; [64] file name position

; Connection types - used in BASIC device I/O
TCPCON	equ	0
TCSCON	equ	1
UDPCON	equ	2
RAWCON	equ	3
HTTCON	equ	4

; Device FCB definitions
DFCBSZ	equ	64		; size of FCB
DFCBBS	equ	058d		; size of the FCB input data buffer to add up to 64 bytes

; MACRO definitions of page changes
ramchpg	MACRO	page
	ld	a,page
	ld	(B1CHG),a
	ENDM
romchpg	MACRO	page
	ld	a,page
	ld	(B2CHG),a
	ENDM
lanchpg	MACRO	page
	ld	a,page
	ld	(B3CHG),a
	ENDM
wrrampg	MACRO
	ld	(B1CHG),a
	ENDM
wrrompg	MACRO
	ld	(B2CHG),a
	ENDM
wrlanpg	MACRO
	ld	(B3CHG),a
	ENDM
grampg	MACRO
	ld	a,(B1CHG)
	ENDM
grompg	MACRO
	ld	a,(B2CHG)
	ENDM
glanpg	MACRO
	ld	a,(B3CHG)
	ENDM

; defintion of character codes to get through CHGET
CHRCLS	equ	0bh			; CLS/HOME key
CHRSEL	equ	018h			; SELECT key
CHRESC	equ	01bh			; ESC key
CHRENT	equ	0dh			; ENTER key
CHRTAB	equ	09h			; TAB key
CHRSPC	equ	020h			; SPACE key
CHRBS	equ	08h			; BACKSPACE key
CHRCTV	equ	016h			; CTRL-V key combination

; Matchpack offsets
MPUIIN	equ	047h			; math pack's unsigned integer input
MPBCDO	equ	04bh			; math pack's double precision output
MPBCDI	equ	053h			; math pack's double BCD input
MPUIO	equ	05bh			; math pack's unsigned integer output
MPMPA1	equ	060h
MPMPA2	equ	064h			; multiplier two arguments
MPMPRE	equ	068h			; multiplier output
MPDCTR	equ	05fh			; division control flags
MPDNUM	equ	070h			; division numerator
MPDENU	equ	074h			; division denominator
MPDQUO	equ	078h			; division quotient
MPDREM	equ	07ch			; division remainder
MPBCLK	equ	090h			; MSX bus clock frequency

; Firmware calls definition
C_DATCOD	equ	05f70h			; get firmware datecode
C_UDPOP	equ	05f73h			; open socket in UDP mode
C_GCURSL	equ	05f76h			; get current slot ID
C_B2OFF	equ	05f79h			; turn GR8NET in CPU bank 2 off
C_B2ON	equ	05f7ch			; turn GR8NET in CPU bank 2 on
C_GWREGS	equ	05f7fh			; get W5100 socket's regs
C_NETCMD	equ	05f82h			; command W5100 socket
C_RX	equ	05f85h			; receive data
C_MMVAR	equ	05f88h			; get memory manager variables
C_DEV8RW	equ	05f8bh			; DEV_RW procedure for Nextor located in subslot 2 in mapper #8 mode
C_PARURI	equ	05f8eh			; parse URI
C_TCPEST	equ	05f91h			; establish TCP connection
C_PUTSTR	equ	05f94h			; print inline string
C_PRSTR	equ	05f97h			; pring formatted string
C_GHCODE	equ	05f9ah			; get HTTP code from the header
C_MGETRQ	equ	05f9dh			; prepare/compile GET request
C_TX	equ	05fa0h			; transmit packet
C_GETDEC	equ	05fa3h			; get 32-bit decimal number from the text stream
C_CHKHIP	equ	05fa6h			; check if host name is IP address
C_CHRPUT	equ	05fa9h			; put character onto the screen
C_PRDE16	equ	05fach			; print 16-bit value onto the screen
C_PRIPA	equ	05fafh			; print IP address in decimal dotted format
C_SCLOSE	equ	05fb2h			; close the socket
C_PRHEX	equ	05fb5h			; print byte in hexadeximal format
