#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

#include "gr8net.h"
#include "utils.h"

typedef struct
{
	char			m_cType;
	char			m_acHostName[32];
	unsigned char	m_aucIPAddress[4];
	unsigned int	m_uiRemotePort;
	unsigned int	m_uiLocalPort;
	char			m_acServerPath[240];
	char			m_acServerFileName[64];
	char			m_acServerQueryString[64];
} tdURI;

char	tcpest(char _cSocket, tdURI *_poURI);
bool	netcmd(char _cSocket, char _cMode);
bool	rx(unsigned int _uiMaxSize, char *_pcBuffer, char _cSocket, unsigned int *_puiBytesRead);
bool	tx(unsigned int _uiSize, char *_pcBuffer, char _cSocket);
void	sclose(char _cSocket);
void	wait();

#define SOCKET_0			0
#define SOCKET_1			1

#define TCP_COMMAND_READ	0
#define TCP_COMMAND_WRITE	1

#define GR8NET_BUFFER_SIZE	2048

bool	g_bSocket0Available = true;
bool	g_bSocket1Available = true;

/*
 =======================================================================================================================
 =======================================================================================================================
 */
unsigned char ucGetSocket()
{
	/*~~~~~~~~~~~~~~~~~~~~~*/
	unsigned char	ucResult;
	/*~~~~~~~~~~~~~~~~~~~~~*/

	if(g_bSocket0Available)
	{
		ucResult = SOCKET_0;
		g_bSocket0Available = false;
	}
	else if(g_bSocket1Available)
	{
		ucResult = SOCKET_1;
		g_bSocket1Available = false;
	}
	else
		vError("No more connections available", NULL);

	return ucResult;
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
unsigned char GR8NET_ucConnectToHostName(unsigned int _uiPort, char *_szHostName)
{
	/*~~~~~~~~~~~~~~~~~~~~~*/
	tdURI			oURI;
	unsigned char	ucResult;
	/*~~~~~~~~~~~~~~~~~~~~~*/

	wait();

	ucResult = ucGetSocket();

	memset(&oURI, 0, sizeof(oURI));
	oURI.m_uiRemotePort = _uiPort;
	oURI.m_cType = 0;
	memcpy(oURI.m_acHostName, _szHostName, sizeof(oURI.m_acHostName) - 1);

	if(tcpest(ucResult, &oURI))
	{
		return 0;
	}
	else
	{
		return ucResult + 1;
	}
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
unsigned char GR8NET_ucConnectToIPAddress(unsigned int _uiPort, unsigned char *_aucIPAddress)
{
	/*~~~~~~~~~~~~~~~~~~~~~*/
	tdURI			oURI;
	unsigned char	ucResult;
	/*~~~~~~~~~~~~~~~~~~~~~*/

	wait();

	ucResult = ucGetSocket();

	memset(&oURI, 0, sizeof(oURI));
	oURI.m_uiRemotePort = _uiPort;
	oURI.m_cType = 2;
	memcpy(oURI.m_aucIPAddress, _aucIPAddress, sizeof(oURI.m_aucIPAddress));

	if(tcpest(ucResult, &oURI))
	{
		return 0;
	}
	else
	{
		return ucResult + 1;
	}
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void GR8NET_vCloseTCPConnection(char _cConnection)
{
	wait();

	_cConnection--;

	sclose(_cConnection);

	if(_cConnection == 0)
	{
		g_bSocket0Available = true;
	}
	else
	{
		g_bSocket1Available = true;
	}
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void GR8NET_vReceiveWithCheck(int _iMaxSize, char *_pcBuffer, char _cConnection, unsigned int *_piBytesRead)
{
	wait();

	_cConnection--;
	*_piBytesRead = 0;


	if(_iMaxSize > GR8NET_BUFFER_SIZE)
	{
		_iMaxSize = GR8NET_BUFFER_SIZE;
	}

	if(rx(_iMaxSize, _pcBuffer, _cConnection, _piBytesRead))
	{
		if(netcmd(_cConnection, TCP_COMMAND_READ))
		{
			vError("Network read command error", NULL);
		}
	}

}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
unsigned int GR8NET_uiSendWithCheck(char _cConnection, char *_pcBuffer, unsigned int _uiSize)
{
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/
	unsigned int	uiSizeToSend;
	/*~~~~~~~~~~~~~~~~~~~~~~~~~*/

	wait();

	_cConnection--;

	uiSizeToSend = (_uiSize < GR8NET_BUFFER_SIZE) ? _uiSize : GR8NET_BUFFER_SIZE;

	if(tx(uiSizeToSend, _pcBuffer, _cConnection))
	{
		if(netcmd(_cConnection, TCP_COMMAND_WRITE)) vError("Network write command error", NULL);
	}

	return uiSizeToSend;
}
