;******************************************************************************
;**                               Variables                                  **
;******************************************************************************


CGTABL equ 0x0004
;  Length: 2
;  Base address of the MSX character set in ROM

  
VDP.DR equ 0x0006
;  Length: 1
;  Base port address for VDP data read


VDP.DW equ 0x0007
;  Length: 1
;  Base port address for VDP data write


BASRVN equ 0x002B
;  Length: 2
;  Basic ROM version
;  0x002B
;7 6 5 4 3 2 1 0
;| | | | +-+-+-+-- Character set
;| | | |           0 = Japanese, 1 = International, 2=Korean
;| +-+-+---------- Date format
;|                 0 = Y-M-D, 1 = M-D-Y, 2 = D-M-Y
;+---------------- Default interrupt frequency
;                  0 = 60Hz, 1 = 50Hz
;  0x002C
;7 6 5 4 3 2 1 0
;| | | | +-+-+-+-- Keyboard type
;| | | |           0 = Japanese, 1 = International
;| | | |           2 = French (AZERTY), 3 = UK, 4 = German (DIN)
;+-+-+-+---------- Basic version
;                  0 = Japanese, 1 = International


MSXVER equ 0x002D
;  Length: 1
;  MSX version number
;      0 = MSX 1
;      1 = MSX 2
;      2 = MSX 2+
;      3 = MSX turbo R

MSXMIDI equ 0x002E
;  Length: 1
;  Bit 0: if 1 then MSX-MIDI is present internally (MSX turbo R only)

;  0x002F
;  Length: 1
;  Reserved


;******************************************************************************
;**                         RST-and other routines                           **
;******************************************************************************

CHKRAM equ 0x0000
;Function : Tests RAM and sets RAM slot for the system
;Registers: All
;Remark   : After this, a jump must be made to INIT, for further initialisation.


SYNCHR equ 0x0008
;Function : tests whether the character of [HL] is the specified character
;           if not, it generates SYNTAX ERROR, otherwise it goes to CHRGTR (#0010)
;Input    : set the character to be tested in [HL] and the character to be
;           compared next to RST instruction which calls this routine (inline parameter)
;Output   : HL is increased by one and A receives [HL], When the tested character is
;           numerical, the CY flag is set the end of the statement (00h or 3Ah) causes
;           the Z flag to be set
;Registers: AF, HL


RDSLT equ 0x000C
;Function : Reads the value of an address in another slot
;Input    : A  - ExxxSSPP
;           |        || Primary  slotnumber  (00-11)
;           |        - Secundary slotnumber (00-11)
;           +----------- Expanded slot (0 = no, 1 = yes)
;           HL - Address to read
;Output   : A  - Contains the value of the read address
;Registers: AF, BC, DE
;Remark   : This routine turns off the interupt, but won't turn it on again


CHRGTR equ 0x0010
;Function : Gets the next character (or token) of the Basic-text
;Input    : HL - Address last character
;Output   : HL - points to the next character
;           A  - contains the character
;           C  - flag set if it's a number
;           Z  - flag set if it's the end of the statement
;Registers: AF, HL


WRSLT equ 0x0014
;Function : Writes a value to an address in another slot.
;Input    : A  - Slot in which the value will be written
;           see RDSLT for input
;           HL - Address of value to write
;           E  - value to write
;Registers: AF, BC, D
;Remark   : See RDSLT


OUTDO equ 0x0018
;Function : Output to current outputchannel (printer, diskfile, etc.)
;Input    : A  - PRTFIL, PRTFLG
;Remark   : Used in basic, in ML it's pretty difficult


CALSLT equ 0x001C
;Function : Executes inter-slot call.
;Input    : IY - High byte with input for A in RDSLT
;           IX - The address that will be called
;Remark   : Variables can never be given in alternative registers
;           of the Z-80 or IX and IY


DCOMPR equ 0x0020
;Function : Compares HL with DE
;Input    : HL, DE
;Output   : Z-flag set if HL and DE are the same.
;Registers: AF


ENASLT equ 0x0024
;Function : Switches indicated slot at indicated page on perpetual
;Input    : A  - ExxxSSPP
;                +-?------ see RDSLT
;           H - Bit 6 and 7 must contain the page number (00-11)


GETYPR equ 0x0028
;Function : Returns Type of DAC
;Input    : DAC
;Output   : S,Z,P/V, CY
;Registers: AF
;Remark   : Not a very clear routine to me, please mail us if you know more about it.


CALLF equ 0x0030
;Function : Executes an interslot call
;Output   : depends on the calling routine
;Registers: AF, and the other registers depending on the calling routine
;Remark   : The following is the calling sequence:
;           RST #30
;           DB destination slot (see RDSLT accu)
;           DW destination address


KEYINT equ 0x0038
;Function : Executes the timer interrupt process routine




;******************************************************************************
;**                        Initialization routines                           **
;******************************************************************************

INITIO equ 0x003B
;Function : Initialises the device
;Registers: All


INIFNK equ 0x003E
;Function : Initialises the contents of the function keys
;Registers: All




;******************************************************************************
;**                                VDP routines                              **
;******************************************************************************

DISSCR equ 0x0041
;Function : inhibits the screen display
;Registers: AF, BC


ENASCR equ 0x0044
;Function : displays the screen
;Registers: AF, BC


WRTVDP equ 0x0047
;Function : write data in the VDP-register
;Input    : B  - data to write
;           C  - number of the register
;Registers: AF, BC


RDVRM equ 0x004A
;Function : Reads the content of VRAM
;Input    : HL - address read
;Output   : A  - value which was read
;Registers: AF


WRTVRM equ 0x004D
;Function : Writes data in VRAM
;Input    : HL - address write
;           A  - value write
;Registers: AF


SETRD equ 0x0050
;Function : Enable VDP to read
;Input    : HL - for VRAM-address
;Registers: AF


SETWRT equ 0x0053
;Function : Enable VDP to write
;Input    : HL - Address
;Registers: AF


FILVRM equ 0x0056
;Function : fill VRAM with value
;Input    : A  - data byte
;           BC - length of the area to be written
;           HL - start address
;Registers: AF, BC


LDIRMV equ 0x0059
;Function : Block transfer to memory from VRAM
;Input    : BC - blocklength
;           DE - Start address of memory
;           HL - Start address of VRAM
;Registers: All


LDIRVM equ 0x005C
;Function : Block transfer to VRAM from memory
;Input    : BC - blocklength
;           DE - Start address of VRAM
;           HL - Start address of memory
;Registers: All


CHGMOD equ 0x005F
;Function : Switches to given screenmode
;Input    : A  - screen mode
;Registers: All


CHGCLR equ 0x0062
;Function : Changes the screencolors
;Input    : Foregroundcolor in FORCLR
;           Backgroundcolor in BAKCLR
;           Bordercolor in BDRCLR
;Registers: All


NMI equ 0x0066
;Function : Executes (non-maskable interupt) handling routine


CLRSPR equ 0x0069
;Function : Initialises all sprites
;Input    : SCRMOD
;Registers: Alles


INITXT equ 0x006C
;Function : Switches to SCREEN 0 (text screen with 40*24 characters)
;Input    : TXTNAM, TXTCGP
;Registers: All


INIT32 equ 0x006F
;Function : Switches to SCREEN 1 (text screen with 32*24 characters)
;Input    : T32NAM, T32CGP, T32COL, T32ATR, T32PAT
;Registers: All


INIGRP equ 0x0072
;Function : Switches to SCREEN 2 (high resolution screen with 256*192 pixels)
;Input    : GRPNAM, GRPCGP, GRPCOL, GRPATR, GRPPAT
;Registers: All


INIMLT equ 0x0075
;Function : Switches to SCREEN 3 (multi-color screen 64*48 pixels)
;Input    : MLTNAM, MLTCGP, MLTCOL, MLTATR, MLTPAT
;Registers: All


SETTXT equ 0x0078
;Function : Switches VDP to SCREEN 0 mode
;Input    : See INITXT
;Registers: All


SETT32 equ 0x007B
;Function : Switches VDP to SCREEN 1 modus
;Input    : See INIT32
;Registers: All


SETGRP equ 0x007E
;Function : Switches VDP to SCREEN 2 mode
;Input    : See INIGRP
;Registers: All


SETMLT equ 0x0081
;Function : Switches VDP to SCREEN 3 mode
;Input    : See INIMLT
;Registers: All


CALPAT equ 0x0084
;Function : Returns the address of the sprite pattern table
;Input    : A  - Sprite ID
;Output   : HL - For the address
;Registers: AF, DE, HL


CALATR equ 0x0087
;Function : Returns the address of the sprite attribute table
;Input    : A  - Sprite number
;Output   : HL - For the address
;Registers: AF, DE, HL


GSPSIZ equ 0x008A
;Function : Returns current sprite size
;Output   : A  - Sprite-size in bytes
;           C-flag set when size is 16*16 sprites otherwise C-flag is reset
;Registers: AF


GRPPRT equ 0x008D
;Function : Displays a character on the graphic screen
;Input    : A  - ASCII value of the character to print




;******************************************************************************
;**                               PSG routines                               **
;******************************************************************************

GICINI equ 0x0090
;Function : Initialises PSG and sets initial value for the PLAY statement
;Registers: All


WRTPSG equ 0x0093
;Function : Writes data to PSG-register
;Input    : A  - PSG register number
;           E  - data write


RDPSG equ 0x0096
;Function : Reads value from PSG-register
;Input    : A  - PSG-register read
;Output   : A  - value read


STRTMS equ 0x0099
;Function : Tests whether the PLAY statement is being executed as a background
;           task. If not, begins to execute the PLAY statement
;Registers: All




;******************************************************************************
;**                               Console routines                           **
;******************************************************************************

CHSNS equ 0x009C
;Function : Tests the status of the keyboard buffer
;Output   : Z-flag set if buffer is filled
;Registers: AF


CHGET equ 0x009F
;Function : One character input (waiting)
;Output   : A  - ASCII-code of the input character
;Registers: AF


CHPUT equ 0x00A2
;Function : Displays one character
;Input    : A  - ASCII-code of character to display


LPTOUT equ 0x00A5
;Function : Sends one character to printer
;Input    : A  - ASCII-code of character to send
;Output   : C-flag set if failed
;Registers: F


LPTSTT equ 0x00A8
;Function : Tests printer status
;Output   : A  - #FF and Z-flag reset if printer is ready
;                #00 and Z-flag set if not ready
;Registers: AF


CNVCHR equ 0x00AB
;Function : tests for the graphic header and transforms the code
;Input    : A  - charactercode
;Output   : the C-flag is reset to not the graphic reader
;           the C-flag and Z-flag are set to the transformed code is set in A
;           the C-flag is set and Z-flag is reset to the untransformed code is set in A
;Registers: AF


PINLIN equ 0x00AE
;Function : Stores in the specified buffer the character codes input until the return
;           key or STOP key is pressed
;Output   : HL - for the starting address of the buffer -1
;           C-flag set when it ends with the STOP key
;Registers: All


INLIN equ 0x00B1
;Function : Same as PINLIN except that AUGFLG (#F6AA) is set
;Output   : HL - for the starting address of the buffer -1
;           C-flag set when it ends with the STOP key
;Registers: All


QINLIN equ 0x00B4
;Function : Prints a questionmark andone space
;Output   : HL - for the starting address of the buffer -1
;           C-flag set when it ends with the STOP key
;Registers: All


BREAKX equ 0x00B7
;Function : Tests status of CTRL-STOP
;Output   : C-flag set when pressed
;Registers: AF
;Remark   : In this routine, interrupts are inhibited


ISCNTC equ 0x00BA
;Function : Tests status of SHIFT-STOP


CKCNTC equ 0x00BD
;Function : Same as ISCNTC. used in Basic


BEEP equ 0x00C0
;Function : generates beep
;Registers: All


CLS equ 0x00C3
;Function : Clears the screen
;Registers: AF, BC, DE
;Remark   : Z-flag must be set to be able to run this routine
;           XOR A will do fine most of the time


POSIT equ 0x00C6
;Function : Moves cursor to a given position
;Input    : H  - Y coordinate of cursor
;           L  - X coordinate of cursor
;Registers: AF


FNKSB equ 0x00C9
;Function : Tests whether the function key display is active (FNKFLG)
;           If so, displays them, otherwise erase them
;Input    : FNKFLG (#FBCE)
;Registers: All


ERAFNK equ 0x00CC
;Function : Erase functionkey display
;Registers: All


DSPFNK equ 0x00CF
;Function : Displays the function keys
;Registers: All


TOTEXT equ 0x00D2
;Function : Forces the screen to be in the text mode
;Registers: All




;******************************************************************************
;**                             Controller routine                           **
;******************************************************************************

GTSTCK equ 0x00D5
;Function : Returns the joystick status
;Input    : A  - Joystick number to test (0 = cursors, 1 = port 1, 2 = port 2)
;Output   : A  - Direction
;Registers: All


GTTRIG equ 0x00D8
;Function : Returns current trigger status
;Input    : A  - trigger button to test
;           0 = spacebar
;           1 = port 1, button A
;           2 = port 2, button A
;           3 = port 1, button B
;           4 = port 2, button B
;Output   : A  - #00 trigger button not pressed
;                #FF trigger button pressed
;Registers: AF


GTPAD equ 0x00DB
;Function : Returns current touch pad status
;Input    : A  - Touchpad number to test
;Output   : A  - Value
;Registers: All


GTPDL equ 0x00DE
;Function : Returns currenct value of paddle
;Input    : A  - Paddle number
;Output   : A  - Value
;Registers: All




;******************************************************************************
;**                             Tape device routines                         **
;******************************************************************************

TAPION equ 0x00E1
;Function : Reads the header block after turning the cassette motor on
;Output   : C-flag set if failed
;Registers: All


TAPIN equ 0x00E4
;Function : Read data from the tape
;Output   : A  - read value
;           C-flag set if failed
;Registers: All


TAPIOF equ 0x00E7
;Function : Stops reading from the tape


TAPOON equ 0x00EA
;Function : Turns on the cassette motor and writes the header
;Input    : A  - #00 short header
;            not #00 long header
;Output   : C-flag set if failed
;Registers: All


TAPOUT equ 0x00ED
;Function : Writes data on the tape
;Input    : A  - data to write
;Output   : C-flag set if failed
;Registers: All


TAPOOF equ 0x00F0
;Function : Stops writing on the tape


STMOTR equ 0x00F3
;Function : Sets the cassette motor action
;Input    : A  - #00 stop motor
;                #01 start motor
;                #FF reverse the current action
;Registers: AF




;******************************************************************************
;**                               Queue routines                             **
;******************************************************************************

LFTQ equ 0x00F6
;Function : Gives number of bytes in queue
;Output   : A  - length of queue in bytes
;Remark   : Internal use


PUTQ equ 0x00F9
;Function : Put byte in queue
;Remark   : Internal use




;******************************************************************************
;**                               Graphic routines                           **
;******************************************************************************

RIGHTC equ 0x00FC
;Function : Shifts screenpixel to the right
;Registers: AF


LEFTC equ 0x00FF
;Function : Shifts screenpixel to the left
;Registers: AF


UPC equ 0x0102
;Function : Shifts screenpixel up
;Registers: AF


TUPC equ 0x0105
;Function : Tests whether UPC is possible, if possible, execute UPC
;Output   : C-flag set if operation would end outside the screen
;Registers: AF


DOWNC equ 0x0108
;Function : Shifts screenpixel down
;Registers: AF


TDOWNC equ 0x010B
;Function : Tests whether DOWNC is possible, if possible, execute DOWNC
;Output   : C-flag set if operation would end outside the screen
;Registers: AF


SCALXY equ 0x010E
;Function : Scales X and Y coordinates


MAPXY equ 0x0111
;Function : Places cursor at current cursor address


FETCHC equ 0x0114
;Function : Gets current cursor addresses mask pattern
;Output   : HL - Cursor address
;           A  - Mask pattern


STOREC equ 0x0117
;Function : Record current cursor addresses mask pattern
;Input    : HL - Cursor address
;           A  - Mask pattern


SETATR equ 0x011A
;Function : Set attribute byte


READC equ 0x011D
;Function : Reads attribute byte of current screenpixel


SETC equ 0x0120
;Function : Returns currenct screenpixel of specificed attribute byte


NSETCX equ 0x0123
;Function : Set horizontal screenpixels


GTASPC equ 0x0126
;Function : Gets screen relations
;Output   : DE, HL
;Registers: DE, HL


PNTINI equ 0x0129
;Function : Initalises the PAINT instruction


SCANR equ 0x012C
;Function : Scans screenpixels to the right


SCANL equ 0x012F
;Function : Scans screenpixels to the left




;******************************************************************************
;**                               Misc routines                              **
;******************************************************************************

CHGCAP equ 0x0132
;Function : Alternates the CAP lamp status
;Input    : A  - #00 is lamp on
;            not #00 is lamp off
;Registers: AF


CHGSND equ 0x0135
;Function : Alternates the 1-bit sound port status
;Input    : A  - #00 to turn off
;            not #00 to turn on
;Registers: AF


RSLREG equ 0x0138
;Function : Reads the primary slot register
;Output   : A  - for the value which was read
;           33221100
;           ||||||- Pagina 0 (#0000-#3FFF)
;           ||||--- Pagina 1 (#4000-#7FFF)
;           ||----- Pagina 2 (#8000-#BFFF)
;           ------- Pagina 3 (#C000-#FFFF)
;Registers: A


WSLREG equ 0x013B
;Function : Writes value to the primary slot register
;Input    : A  - value value to (see RSLREG)


RDVDP equ 0x013E
;Function : Reads VDP status register
;Output   : A  - Value which was read
;Registers: A


SNSMAT equ 0x0141
;Function : Returns the value of the specified row from the keyboard matrix
;Input    : A  - for the specified row
;Output   : A  - for data (the bit corresponding to the pressed key will be 0)
;Registers: AF
;          bit 7  bit 6  bit 5  bit 4  bit 3  bit 2  bit 1  bit 0
;  row 0    7 &    6 ^    5 %    4 $    3 #    2 @    1 !    0 )
;  row 1    ; :    ] }    [ {    \ ¦    = +    - _    9 (    8 *
;  row 2     B      A    DEAD    / ?    . >    , <    ` ~    ' "
;  row 3     J      I      H      G      F      E      D      C
;  row 4     R      Q      P      O      N      M      L      K
;  row 5     Z      Y      X      W      V      U      T      S
;  row 6    F3     F2     F1    CODE   CAPS   GRAPH   CTRL  SHIFT
;  row 7    RET  SELECT   BS    STOP    TAB    ESC    F5     F4
;  row 8     →      ↓      ↑      ←     DEL    INS    HOME  SPACE
;  row 9   NUM4   NUM3   NUM2   NUM1   NUM0   NUM/    NUM+  NUM*
;  row 10  NUM.   NUM,   NUM-   NUM9   NUM8   NUM7    NUM6  NUM5


PHYDIO equ 0x0144
;Function : Executes I/O for mass-storage media like diskettes
;Input    : B  - Number of sectors
;           C  - Media ID of the disk
;           DE - Begin sector
;           HL - Begin address in memory
;Registers: All
;Remark   : Before the call is called, the Z-flag must be reset, and the execution
;           address which was in HL must be at the last stack address
;           By the way: In minimum configuration only a HOOK is available


FORMAT equ 0x0147
;Function : Initialises mass-storage media like formatting of diskettes
;Registers: All
;Remark   : In minimum configuration only a HOOK is available


ISFLIO equ 0x014A
;Function : Tests if I/O to device is taking place
;Output   : A  - #00 if not taking place
;            not #00 if taking place
;Registers: AF


OUTDLP equ 0x014D
;Function : Printer output
;Input    : A  - code to print
;Registers: F
;Remark   : Differences with LPTOUT:
;           1. TAB is expanded to spaces
;           2. For non-MSX printers, Hiragana is transformed to katakana
;              and graphic characters are transformed to 1-byte characters
;           3. If failed, device I/O error occurs


GETVCP equ 0x0150
;Function : Returns pointer to play queue
;Input    : A  - Channel number
;Output   : HL - Pointer
;Registers: AF
;Remark   : Only used to play music in background


GETVC2 equ 0x0153
;Function : Returns pointer to variable in queue number VOICEN (byte op #FB38)
;Input    : L  - Pointer in play buffer
;Output   : HL - Pointer
;Registers: AF


KILBUF equ 0x0156
;Function : Clear keyboard buffer
;Registers: HL


CALBAS equ 0x0159
;Function : Executes inter-slot call to the routine in BASIC interpreter
;Input    : IX - for the calling address
;Output   : Depends on the called routine
;Registers: Depends on the called routine